-----------------------------------------------------------------------------
-- MapName: XXX
-- Author: XXX
-- MPComfort Skript: Anarki, Support: www.dedk.de und www.dedk.de/wiki
-----------------------------------------------------------------------------

function GameCallback_OnGameStart()

	-- Include global tool script functions
	--Script.Load(Folders.MapTools.."Ai\\Support.lua")
	Script.Load( "Data\\Script\\MapTools\\MultiPlayer\\MultiplayerTools.lua" )
	Script.Load( "Data\\Script\\MapTools\\Tools.lua" )
	Script.Load( "Data\\Script\\MapTools\\WeatherSets.lua" )
	IncludeGlobals("Comfort")

	-- Init  global MP stuff
	MultiplayerTools.InitCameraPositionsForPlayers()
	MultiplayerTools.SetUpGameLogicOnMPGameConfig()
    if XNetwork.Manager_DoesExist() == 0 then
        Logic.PlayerSetIsHumanFlag( GUI.GetPlayerID(), 1 )
        Logic.PlayerSetGameStateToPlaying( GUI.GetPlayerID() )
	end
	
	MPCOMFORT()
	
	--AllesHacken()
	LoadComforts()	
	MPC_Initialisierung()
	SpecialMapInitialization()
	AddPeriodicSummer(10)
end

function MPCOMFORT()


-- FOLGENDEN CODE NICHT VERAENDERN => COMFORTS
function MPC_Debug()
	for i = 1,250 do
		Game.GameTimeSpeedUp()
	end
	mpc_GameStartDelay = 1
	table.foreach(g_MC_StR,
		function(_index)
			g_MC_StR[_index] = 100000
		end
	)
	mpc_GameStartDelay = 1
	for _pId = 1,8 do
		Tools.GiveResouces(_pId, g_MC_StR.Gold , g_MC_StR.Clay, g_MC_StR.Wood, g_MC_StR.Stone, g_MC_StR.Iron, g_MC_StR.Sulfur)
		Logic.SetEntityExplorationRange ( Logic.CreateEntity( Entities.XD_ScriptEntity, 30000+_pId, 30000+_pId, 0, _pId ), 50000 )
		table.foreach(Technologies, function(key,value)
				ResearchTechnology(value,_pId)
		end)
		-- nen held erzeugen fr CTF
		for u = 1,3 do
			if table.getn(Track_Entity_Table[_pId][gv_Entities_HQs[u]]) > 0 then
				local _pos = GetPosition(Track_Entity_Table[_pId][gv_Entities_HQs[u]][1])
				--table.insert(CtF_Helden[_pId],_eId)
				Logic.CreateEntity( Entities.PU_Hero1, _pos.X-1000, _pos.Y, 0, 0 )
			end
		end
			
	end

	
	--if XNetwork.Manager_DoesExist() == 0 then
	--	mpc_playerteams = {1,2,1,2,1,2,1,2}
	--end
	testjob = function()
		--Message(Track_Entity_Table[1][Entities.PB_Residence1].count)
		--Message(table.getn(Track_Entity_Table[1][Entities.PB_Residence1]))
	end
	StartSimpleJob("testjob")
	-- zeigt die Widget IDs
	--table.foreach(_G     ,	
	--	function (was) 
	--		if string.find(was, "GUITooltip") and not(string.find(was, "_BeforeOrig")) and not(string.find(was, "_AfterOrig")) and not(string.find(was, "_OrigProtected")) then
	--			Message(was.."_BeforeOrig")
	--			table.insert(_G[was.."_BeforeOrig"],
	--			function(...)			
	--				_mapname = "Widget ID: "..XGUIEng.GetCurrentWidgetID()
	--				_mapper = arg[1]
	--				if _mapper == nil then
	--					_mapper = ""
	--				end
	--				_version = ""
	--				_specialtext = ""
	--				MapVersion_Write_Comfort(_mapname, _mapper, _version, _specialtext)
	--				Message("Widget ID: "..XGUIEng.GetCurrentWidgetID())
	--			end
	--			)
	--		end
	--	end)
end

function LoadComforts()
	-- Laden der bentigten Comforts
	Setup_GUIHacks()
	CxToolsInclude()
	Countdown_and_Peacetime()
	Comfort_TrackEntitysIni()
	Tribute_Comforts()
	Globale_Hilfsvariablen_und_Funktionen()
	CaptureTheFlagInit()
	MovieFensterTooltip()
	MPC_Initialize()
	
	MapspezifischeEinstellungen()
	
	--StatisticLogging()
end
function CxToolsInclude()
	CxTools = CxTools or {}; 
	 
	function CxTools:Init()
		CxTools:InitUnpackFix();
		CxTools:InitTriggers();
	end
	 
	--#########################################################################
	--###
	--###	 Utility Functions
	--###
	 
	function CxTools.Panic(_text)
		Message("-----------------------------------------");
		Message("Error: " .. tostring(_text));
		Message("-----------------------------------------");
		--assert(false,tostring(_text))
		local _table = { text = _text };
		StartSimpleJob(CxTools.GlobalTriggerDebug, _table);
	end
	function CxTools.PanicOrig(_text)
		Message("Hallo Welt")
		assert(false,tostring(_text))
	end	
	--#########################################################################
	--###
	--###	 unpack()-Fix
	--###
	 
	function CxTools:InitUnpackFix()
		if not unpack{true} then
			local unpack2;
			unpack2 =
				function(_table, _i)
					_i = _i or 1;
					assert(type(_table) == "table");
					if _i <= table.getn(_table) then
						return _table[_i], unpack2(_table, _i + 1);
					end
				end
	 
			unpack = unpack2;    
		end
	end
	 
	--#########################################################################
	--###
	--###	 Trigger Functions
	--###
	 
	--Trigger-Fix / improvement
	function CxTools:InitTriggers()
		CxTools.tTriggers = {};
		CxTools.nTriggerNum = 0;
		CxTools.GlobalTriggerConditionCallbackWrapperName = "TriggerConditionCallbackWrapper";
		CxTools.GlobalTriggerActionCallbackWrapperName = "TriggerActionCallbackWrapper";
		CxTools.GlobalTriggerDebug = "MessageTriggerDebug";
	 
		CxTools.Mission_OnSaveGameLoaded = Mission_OnSaveGameLoaded;
		Mission_OnSaveGameLoaded = function() CxTools:HookAPITrigger(); CxTools.Mission_OnSaveGameLoaded(); end;
		CxTools:HookAPITrigger();
	 
		assert( not _G[CxTools.GlobalTriggerConditionCallbackWrapperName] );
		_G[CxTools.GlobalTriggerConditionCallbackWrapperName] = 
			function(_sId)
				return CxTools:callbackWrapperCondition(_sId);
			end
	 
		assert( not _G[CxTools.GlobalTriggerActionCallbackWrapperName] );
		_G[CxTools.GlobalTriggerActionCallbackWrapperName] = 
			function(_sId)
				return CxTools:callbackWrapperAction(_sId);
			end
	 
		--Comfort Functions
		CxTools.StartSimpleJobOrig = StartSimpleJob;
		StartSimpleJob = 
			 function(...)
				 return CxTools:StartSimpleJob(unpack(arg));
			 end
	 
		CxTools.StartSimpleHiResJobOrig = StartSimpleHiResJob;
			StartSimpleHiResJob = 
				function(...)
					return CxTools:StartSimpleHiResJob(unpack(arg));
				end
	 
		CxTools.StartJobOrig = StartJob;
		StartJob = 
			function(...)
				return CxTools:StartJob(unpack(arg));
			end
	 
		CxTools.StartHiResJobOrig = StartHiResJob;
		StartHiResJob = 
			function(...)
				return CxTools:StartHiResJob(unpack(arg));
			end
		
		
		assert( not _G[CxTools.GlobalTriggerDebug] );
		_G[CxTools.GlobalTriggerDebug] = 
			function(_table)
				assert(type(_table) == "table");
				_table.seconds = _table.seconds or 0;
				_table.seconds = _table.seconds + 1;
				if math.mod(_table.seconds, 15) == 0 then
							Message("-----------------------------------------");
							Message("Error: " .. tostring(_table.text));
							Message("-----------------------------------------");
					if _table.seconds == 45 then
					return true;
				end
				end
			end
		
	end
	 
	function CxTools:HookAPITrigger()
		CxTools.RequestTriggerOrig = Trigger.RequestTrigger;
		CxTools.UnrequestTriggerOrig = Trigger.UnrequestTrigger;
		Trigger.RequestTrigger = 
			function(_event, _fCond, _fAction, _isActive, _pCond, _pAction)
				return CxTools:AddTrigger(_event, _fCond, _fAction, _isActive, _pCond, _pAction);
			end
		Trigger.UnrequestTrigger =
			function( _id )
				CxTools:UnrequestTrigger( _id );
			end
	end
	 
	function CxTools:AddTrigger( _eventType, _funcCondition, _funcAction, _isActive, _paramsCond, _paramsAction )
		assert(type(_eventType) == "number");
		assert(not _funcCondition or type(_funcCondition) == "string" or type(_funcCondition) == "function" );
		assert(type(_funcAction) == "string" or type(_funcAction) == "function");
	 
		if _isActive == true then
			_isActive = 1;
		elseif _isActive == false then
			_isActive = 0;
		else
			assert( type(_isActive) == "number" and (_isActive == 0 or _isActive == 1) );
		end
	 
		_paramsCond = _paramsCond or {};
		_paramsAction = _paramsAction or {};
	 
		local sTriggerId = table.getn(CxTools.tTriggers) + 1;
		if sTriggerId > CxTools.nTriggerNum then
			CxTools.nTriggerNum = sTriggerId;
		end
	 
		local entry = {};
		entry.sId = sTriggerId;
		if _funcCondition ~= "" then
			 entry.funcCondition = _funcCondition;
		end
		entry.funcAction = _funcAction;
		entry.paramsCond = _paramsCond;
		entry.paramsAction = _paramsAction;
	 
		local condition = CxTools.GlobalTriggerConditionCallbackWrapperName;
		local action = CxTools.GlobalTriggerActionCallbackWrapperName;
		if not _funcCondition or _funcCondition == "" then
			condition = nil;
		end
	 
		local realTriggerId = CxTools.RequestTriggerOrig( _eventType, condition, action, _isActive, {sTriggerId}, {sTriggerId} );
		entry.realId = realTriggerId;
	 
		CxTools.tTriggers[sTriggerId] = entry;
	 
		return realTriggerId;
	end
	 
	function CxTools:callbackWrapperCondition( _sTriggerId )
		tRes = { xpcall( function() return CxTools:callbackWrapperConditionReal( _sTriggerId ); end, CxTools.Panic ) };
		table.remove( tRes, 1 );
		return unpack( tRes );
	end
	 
	function CxTools:callbackWrapperConditionReal( _sTriggerId )
		assert(type( _sTriggerId) == "number" );
		local entry = CxTools.tTriggers[_sTriggerId];
		assert( entry );
		assert( entry.sId == _sTriggerId );
		assert( entry.funcCondition );
		assert( entry.paramsCond );
	 
		local tRes;
		if type(entry.funcCondition) == "function" then
			tRes = { xpcall( function() return entry.funcCondition( unpack( entry.paramsCond ) ); end, CxTools.Panic ) };
		else
			local f = _G[entry.funcCondition];
			assert(type(f) == "function");
			tRes = { xpcall( function() return f( unpack( entry.paramsCond ) ); end, CxTools.Panic ) };
		end
	 
		local bNoErr = table.remove( tRes, 1 );
	 
		if not bNoErr then
			CxTools.tTriggers[_sTriggerId].err = true;
		end
	 
		return bNoErr and unpack( tRes ) or not bNoErr;
	end
	 
	function CxTools:callbackWrapperAction( _sTriggerId )
		tRes = { xpcall( function() return CxTools:callbackWrapperActionReal( _sTriggerId ); end, CxTools.PanicOrig ) };
		table.remove( tRes, 1 );
		return unpack( tRes );
	end
	 
	function CxTools:callbackWrapperActionReal( _sTriggerId )
		assert(type( _sTriggerId) == "number" );
		local entry = CxTools.tTriggers[_sTriggerId];
		assert( entry );
		assert( entry.sId == _sTriggerId );
		assert( entry.funcAction );
		assert( entry.paramsAction );
	 
		local bNoErr = true;
		local tRes;
		if not entry.err then
			if type(entry.funcAction) == "function" then
				tRes = { xpcall( function() return entry.funcAction( unpack( entry.paramsAction ) ); end, CxTools.Panic ) };
			
			else
				local f = _G[entry.funcAction];
				assert(type(f) == "function");
				tRes = { xpcall( function() return f( unpack( entry.paramsAction ) ); end, CxTools.Panic ) };
			end
	 
			bNoErr = table.remove( tRes, 1 );
		end
	 
		-- check return value
		if not bNoErr or entry.err or tRes[1] == true then
			-- Remove this entry, as the trigger is destroyed
			CxTools.tTriggers[_sTriggerId] = nil;
		end
	 
		return entry.err or (bNoErr and unpack( tRes ) or not bNoErr);
	end 
	 
	function CxTools:UnrequestTrigger( _id )
		--assert( type( _id ) == "number" );
		for i = 1, CxTools.nTriggerNum, 1 do
			local t = CxTools.tTriggers[i];
			if t and t.realId == _id then
				CxTools.tTriggers[i] = nil;
				break;
			end
		end
		CxTools.UnrequestTriggerOrig( _id );
	end
	 
	 
	--#########################################################################
	--###
	--###	 Trigger Comfort Functions
	--###
	 
	function CxTools:StartSimpleJob( _functionname, ...)
		assert(type(_functionname) == "string" or type(_functionname) == "function");
	 
		if type(_functionname) == "string" then
			if arg[1] == nil then 
				return CxTools.StartSimpleJobOrig( _functionname );
	 
			else
				assert(type(_G[_functionname]) == "function");
				return Trigger.RequestTrigger( Events.LOGIC_EVENT_EVERY_SECOND, "", _functionname, 1, {}, arg );
			end
	 
		else
			assert(type(_functionname) == "function");
			return Trigger.RequestTrigger( Events.LOGIC_EVENT_EVERY_SECOND, "", _functionname, 1, {}, arg );
		end
	end
	 
	function CxTools:StartSimpleHiResJob( _functionname, ...)
		assert(type(_functionname) == "string" or type(_functionname) == "function");
	 
		if type(_functionname) == "string" then
			if arg[1] == nil then 
				return CxTools.StartSimpleHiResJobOrig( _functionname );
	 
			else
				assert(type(_G[_functionname]) == "function");
				return Trigger.RequestTrigger( Events.LOGIC_EVENT_EVERY_TURN, "", _functionname, 1, {}, arg );
			end
	 
		else
			assert(type(_functionname) == "function");
			return Trigger.RequestTrigger( Events.LOGIC_EVENT_EVERY_TURN, "", _functionname, 1, {}, arg );
		end
	end
	 
	function CxTools:StartJob( _functionname, ... )
		assert(type(_functionname) == "string" or (type(_functionname) == "function" and type(arg[1]) == "function"));
	 
		if type(_functionname) == "string" then
	 
			assert(type(_G["Action_".._functionname]) == "function" and type(_G["Condition_".._functionname]) == "function");
	 
			if arg[1] == nil then
				return CxTools.StartJobOrig(_functionname);
	 
			else
				assert(type(arg[1]) == "table" and (not arg[2] or type(arg[2]) == "table"));
				return Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_SECOND, "Condition_".._functionname, "Action_".._functionname, 1, arg[2], arg[1]);
			end
		else
			 assert((not arg[2] or type(arg[2]) == "table") and (not arg[3] or type(arg[3]) == "table"));
			 return Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_SECOND, arg[1], _functionname, 1, arg[3], arg[2]);
		 end
	end
	 
	function CxTools:StartHiResJob( _functionname, ... )
		assert(type(_functionname) == "string" or (type(_functionname) == "function" and type(arg[1]) == "function"));
	 
		if type(_functionname) == "string" then
	 
			assert(type(_G["Action_".._functionname]) == "function" and type(_G["Condition_".._functionname]) == "function");
	 
			if arg[1] == nil then
				return CxTools.StartHiResJobOrig(_functionname);
	 
			else
				assert(type(arg[1]) == "table" and (not arg[2] or type(arg[2]) == "table"));
				return Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_TURN, "Condition_".._functionname, "Action_".._functionname, 1, arg[2], arg[1]);
			end
		else
			assert((not arg[2] or type(arg[2]) == "table") and (not arg[3] or type(arg[3]) == "table"));
			return Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_TURN, arg[1], _functionname, 1, arg[3], arg[2]);
		end
	end
	 
	--#########################################################################
	--###
	--###	 Init!
	--###
	 
	CxTools:Init();
end
function Countdown_and_Peacetime()
	
	PeacetimeEnd = function()
		-- smtliche Aktionen bei Ende der Friedenszeit
		MultiplayerTools.SetUpDiplomacyOnMPGameConfig()
		SpecialPeacetimeEnd()
		-- Sound bei Ende der Friedenszeit
		Sound.PlayGUISound( Sounds.OnKlick_Select_kerberos, 127 )
		-- Nachricht bei Ende der Friedenszeit
		Message( "@color:255,255,0 "..g_MC_Loc[lang].Wartimemsg );
		
		-- Schnee und Brcke freischalten wenn erlaubt
		for _pId = 1,8 do
			if mpc_Rules["Weather"].Act[1] == true then AllowTechnology(Technologies.T_MakeSnow, _pId); end
			if mpc_Rules["Buildings1"].Act[4] == true then AllowTechnology(Technologies.B_Bridge, _pId); end
		end
		
		-- Blockende Gegenstnde zerstren oder bei Toren ersetzen
		for i = 1, table.getn(gvBlocking) do			
			local _eType = Logic.GetEntityType( gvBlocking[i] )
			if _eType == Entities.XD_PalisadeGate1 then
				ReplaceEntity (gvBlocking[i], Entities.XD_PalisadeGate2 )
			elseif _eType == Entities.XD_WallStraightGate_Closed then
				ReplaceEntity (gvBlocking[i], Entities.XD_WallStraightGate )
			elseif _eType == Entities.XD_DarkWallStraightGate_Closed then
				ReplaceEntity (gvBlocking[i], Entities.XD_DarkWallStraightGate )
			else
				DestroyEntity(gvBlocking[i])
			end		
		end	
		
		-- CtF Funktion starten falls aktiviert
		if mpc_Rules["FlagActive"].Act[1] then
			StartSimpleJob("CaptureTheFlagJob")
		end
		SpecialMapPeaceTimeEndActions()
	end

	SetPeacetime = function ( _seconds )
		---hier wird die Funktion special peacetime gestartet
		SpecialPeacetime();
		StartCountdown( _seconds, PeacetimeEnd, true );
	end

	SpecialPeacetime = function()
		-- Anzahl der menschlichen Spieler wird hier ermittelt
		local _humenPlayer = XNetwork.GameInformation_GetMapMaximumNumberOfHumanPlayer()
		-- Abfrage ob Standardsituation gegeben ist das jeder sich  mit jedem  verbnden kann
		if XNetwork.GameInformation_GetFreeAlliancesFlag() == 1 then
			-- Feststellung wer mit wem verbndet ist und Festlegung des DiplomatiST fr die Peacetime
			if _humenPlayer > 1 then
				for _teampId = 1, _humenPlayer do
					local _teamplayer = mpc_playerteams[_teampId]
					for _oppopId = 1, _humenPlayer do
						if _teampId ~= OppoPlayer then
							local _oppoPlayer = mpc_playerteams[_oppopId]
							if _teamplayer == _oppoPlayer then
								Logic.SetDiplomacyState( _oppopId, _teampId, Diplomacy.Friendly )
							else
								Logic.SetDiplomacyState( _oppopId, _teampId, Diplomacy.Neutral )
							end
						end
					end
				end
			end
		end
	end
	SpecialPeacetimeEnd = function()
		for _teampId = 1, 8 do
			for _oppopId = 1, 8 do
				if _teampId ~= OppoPlayer then
					if mpc_playerteams[_teampId] == mpc_playerteams[_oppopId] then
						Logic.SetDiplomacyState( _oppopId, _teampId, Diplomacy.Friendly )
					else
						Logic.SetDiplomacyState( _oppopId, _teampId, Diplomacy.Hostile )
					end
				end
			end
		end
	end
	
	
	StartCountdown = function (_Limit, _Callback, _Show)
		assert(type(_Limit) == "number")

		Counter.Index = (Counter.Index or 0) + 1

		if _Show and CountdownIsVisisble() then
			assert(false, "StartCountdown: A countdown is already visible")
		end

		Counter["counter" .. Counter.Index] = {Limit = _Limit, TickCount = 0, Callback = _Callback, Show = _Show, Finished = false}

		if _Show then
			MapLocal_StartCountDown(_Limit)
		end

		if Counter.JobId == nil then
			Counter.JobId = StartSimpleJob("CountdownTick")
		end

		return Counter.Index
	end

	StopCountdown = function(_Id)
		if Counter.Index == nil then
			return
		end

		if _Id == nil then
			for i = 1, Counter.Index do
				if Counter.IsValid("counter" .. i) then
					if Counter["counter" .. i].Show then
						MapLocal_StopCountDown()
					end
					Counter["counter" .. i] = nil
				end
			end
		else
			if Counter.IsValid("counter" .. _Id) then
				if Counter["counter" .. _Id].Show then
					MapLocal_StopCountDown()
				end
				Counter["counter" .. _Id] = nil
			end
		end
	end

	CountdownTick = function()
		local empty = true
		for i = 1, Counter.Index do
			if Counter.IsValid("counter" .. i) then
				if Counter.Tick("counter" .. i) then
					Counter["counter" .. i].Finished = true
				end

				if Counter["counter" .. i].Finished and not IsBriefingActive() then
					if Counter["counter" .. i].Show then
						MapLocal_StopCountDown()
					end

					-- callback function
					if type(Counter["counter" .. i].Callback) == "function" then
						Counter["counter" .. i].Callback()
					end

					Counter["counter" .. i] = nil
				end

				empty = false
			end
		end

		if empty then
			Counter.JobId = nil
			Counter.Index = nil
			return true
		end
	end
	
	CountdownGetTick = function(_Id)
		if Counter.IsValid("counter" .. _Id) then
			return Counter["counter" .. _Id].Limit-Counter["counter" .. _Id].TickCount
		else
			return 0
		end
	end
	
	CountdownIsVisisble = function()
		for i = 1, Counter.Index do
			if Counter.IsValid("counter" .. i) and Counter["counter" .. i].Show then
				return true
			end
		end
		return false
	end
	
end

function SucheAufDerWelt(_player, _entity, _groesse, _punkt)
	local punktX1, punktX2, punktY1, punktY2, data
	local gefunden = {}
	local rueck
	if not _groesse then
		_groesse = Logic.WorldGetSize() 
	end
	if not _punkt then
		_punkt = {X = _groesse/2, Y = _groesse/2}
	end
	if _player == 0 then
		data ={Logic.GetEntitiesInArea(_entity, _punkt.X, _punkt.Y, math.floor(_groesse * 0.71), 16)}
	else
		data ={Logic.GetPlayerEntitiesInArea(_player,_entity, _punkt.X, _punkt.Y, math.floor(_groesse * 0.71), 16)}
	end
	if data[1] >= 16 then -- Aufteilen angesagt
		local _klgroesse = _groesse / 2 
		-- Ausgangspunkt ist _punkt
		-- _punkt verteilen
		local punktX1 = _punkt.X - _groesse / 4
		local punktX2 = _punkt.X + _groesse / 4
		local punktY1 = _punkt.Y - _groesse / 4
		local punktY2 = _punkt.Y + _groesse / 4
		rueck = SucheAufDerWelt(_player, _entity, _klgroesse, {X=punktX1,Y=punktY1})
		for i = 1, table.getn(rueck) do
			if not IstDrin(rueck[i], gefunden) then
				table.insert(gefunden, rueck[i])
			end
		end
		rueck = SucheAufDerWelt(_player, _entity, _klgroesse, {X=punktX1,Y=punktY2})
		for i = 1, table.getn(rueck) do
			if not IstDrin(rueck[i], gefunden) then
				table.insert(gefunden, rueck[i])
			end
		end
		rueck = SucheAufDerWelt(_player, _entity, _klgroesse, {X=punktX2,Y=punktY1})
		for i = 1, table.getn(rueck) do
			if not IstDrin(rueck[i], gefunden) then
				table.insert(gefunden, rueck[i])
			end
		end
		rueck = SucheAufDerWelt(_player, _entity, _klgroesse, {X=punktX2,Y=punktY2})
		for i = 1, table.getn(rueck) do
			if not IstDrin(rueck[i], gefunden) then
				table.insert(gefunden, rueck[i])
			end
		end
	else
		table.remove(data,1)
		for i = 1, table.getn(data) do
			if not IstDrin(data[i], gefunden) then
				table.insert(gefunden, data[i])
			end
		end
	end
	return gefunden
end
function IstDrin(_wert, _table)
  for i = 1, table.getn(_table) do
    if _table[i] == _wert then 
        return true 
    end 
  end
  return false
end

function Comfort_TrackEntitysIni()	
	-- Trackt alle initialisierten Entitys
	Track_Entity_Table = {}
	for _pId = 0,8 do
		Track_Entity_Table[_pId] = {}
	end
	Comfort_TrackEntityIni = function(_pId,_eType)
		Track_Entity_Table[_pId][_eType] = {}
		Track_Entity_Table[_pId][_eType].tracked = true
		if not(_pId == 0) then
			local temp = {Logic.GetPlayerEntities(_pId, _eType,1)}
			if temp[1] > 0 then
				local latestEntity = temp[2]
				for u = 1, Logic.GetNumberOfEntitiesOfTypeOfPlayer(_pId, _eType) do
					if latestEntity ~= 0 then
						table.insert(Track_Entity_Table[_pId][_eType], latestEntity)
					end		
					latestEntity = Logic.GetNextEntityOfPlayerOfType(latestEntity);
				end
			end			
		else
			Track_Entity_Table[_pId][_eType] = SucheAufDerWelt(_pId,_eType)
		end
	end
	
	Comfort_TrackEntity_Created = function(_eId,_pId)
		if _eId == nil then
			_eId = Event.GetEntityID()
			_pId = GetPlayer(_eId)
		end
		local _eType = Logic.GetEntityType(_eId)
		--if Logic.IsBuilding(_eId) == 1 then
		if Comfort_TrackEntity_IsTracked(_pId,_eType) then
			if Track_Entity_Table[_pId][_eType].tracked then
				local _drin = false
				for i = 1, table.getn(Track_Entity_Table[_pId][_eType]) do
					if _eId == Track_Entity_Table[_pId][_eType][i] then
						_drin = true
						break
					end
				end
				if not _drin then
					table.insert(Track_Entity_Table[_pId][_eType], _eId)
				end
			end
		end
	end
	
	Comfort_TrackEntity_Destroyed = function()
		local _eId = Event.GetEntityID()
		local _pId = GetPlayer(_eId)
		local _eType = Logic.GetEntityType(_eId)
		if Comfort_TrackEntity_IsTracked(_pId,_eType) then					
			for i = 1, table.getn(Track_Entity_Table[_pId][_eType]) do
				if _eId == Track_Entity_Table[_pId][_eType][i] then
					table.remove(Track_Entity_Table[_pId][_eType], i)
					break
				end
			end
		end	
	end	
	
	Comfort_TrackEntity_IsTracked = function(_pId, _eType, _TypeOrId)
		if _TypeOrId == false then _eType = Logic.GetEntityType(_eTypeOrId) end
		if type(Track_Entity_Table[_pId]) == "table" then
			if type(Track_Entity_Table[_pId][_eType]) == "table" then
			else return false
			end
		else return false
		end
		return Track_Entity_Table[_pId][_eType].tracked	
	end		
	Comfort_TrackEntity_RemoveTracking = function(_pId, _eType)
		Track_Entity_Table[_pId][_eType] = {}
		Track_Entity_Table[_pId][_eType].tracked = false
	end
	Comfort_TrackEntity_GetCount = function(_pId,_eType,_onlyConstructed)
		assert( type(_pId) == "number", "Spieler ID muss Zahl sein!" )
		assert( type(_eType) == "number", "Entity Typ muss Zahl sein!" )
		assert( Comfort_TrackEntity_IsTracked(_pId,_eType), "Entity Typ wird nicht getrackt!" )
		_onlyConstructed = _onlyConstructed or false
		if not(_onlyConstructed) then
			return table.getn(Track_Entity_Table[_pId][_eType])
		else
			local _count = 0	
			for i = 1, table.getn(Track_Entity_Table[_pId][_eType]) do
				_count = _count + Logic.IsConstructionComplete(Track_Entity_Table[_pId][_eType][i]) 
			end
			return _count
		end
	end
	
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "Comfort_TrackEntity_Created", 1)
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_DESTROYED, "", "Comfort_TrackEntity_Destroyed", 1)
end

function Tribute_Comforts()

	AddTribute = function( _tribute )
		assert( type( _tribute ) == "table", "Tribut mu ein Table sein" );
		assert( type( _tribute.text ) == "string", "Tribut.text mu ein String sein" );
		assert( type( _tribute.cost ) == "table", "Tribut.cost mu ein Table sein" );
		assert( type( _tribute.pId ) == "number", "Tribut.pId mu eine Nummer sein" );
		assert( not _tribute.Tribute , "Tribut.Tribute darf nicht vorbelegt sein");

		uniqueTributeCounter = uniqueTributeCounter or 1;
		_tribute.Tribute = uniqueTributeCounter;
		uniqueTributeCounter = uniqueTributeCounter + 1;

		local tResCost = {};
		for k, v in pairs( _tribute.cost ) do
			assert( ResourceType[k] );
			assert( type( v ) == "number" );
			table.insert( tResCost, ResourceType[k] );
			table.insert( tResCost, v );
		end

		Logic.AddTribute( _tribute.pId, _tribute.Tribute, 0, 0, _tribute.text, unpack( tResCost ) );
		SetupTributePaid( _tribute );
		return _tribute.Tribute;
	end

	CreateATribute = function(_pId, _text, _cost, _callback)
		local tribute =  {};
		tribute.pId = _pId;
		tribute.text = _text;
		tribute.cost = _cost;
		tribute.Callback = _callback;
		return tribute
	end

	GameCallback_FulfillTribute = function()
		return 1
	end


end

function Globale_Hilfsvariablen_und_Funktionen()
	
	-- *** Variablen ***
	
	-- GUI Player ID in globale Variable legen
	gv_guipId = GUI.GetPlayerID()

	-- Spieler in globale Variable legen
	mpc_playernames = {}
	mpc_playerteams = {}
	for i = 1,8 do
		mpc_playernames[i] = XNetwork.GameInformation_GetLogicPlayerUserName(i)
		mpc_playerteams[i] = XNetwork.GameInformation_GetLogicPlayerTeam(i)
	end

	gv_Entities_Tuerme = {Entities.PB_Tower1, 
						Entities.PB_Tower2, 
						Entities.PB_Tower3,
						Entities.PB_DarkTower1,
						Entities.PB_DarkTower2,
						Entities.PB_DarkTower3,
						Entities.PB_Beautification03}
	gv_Entities_Dorfzentren = {Entities.PB_VillageCenter1, 
							Entities.PB_VillageCenter2, 
							Entities.PB_VillageCenter3}
	gv_Entities_HQs = {	Entities.PB_Headquarters1, 
					Entities.PB_Headquarters2, 
					Entities.PB_Headquarters3}						

	gvCol = {
		weiss = "@color:255,255,255",
		schwarz = "@color:0,0,0",
		rot = "@color:255,0,0",
		gelb = "@color:255,232,0",
		gruen = "@color:0,255,0",
		dunkelgruen = "@color:0,100,0",
		blau = "@color:0,0,255",
		lila = "@color:200,0,200",
		grau = "@color:150,150,150",
		tuerkis = "@color:0,180,180",
		orange = "@color:255,130,0",
		beige = "@color:190,190,150",
		hellgrau = "@color:170,170,170",
		dunkelgrau = "@color:120,120,120",
		TTgelb = "@color:255,200,0",
		TTrot = "@color:200,60,0",
		TUTgruen = "@color:90,190,20",
		space = "@color:0,0,0,0",
	}
	-- nach SpielerFarbenID indiziert (bzw Farbennamen)
	gv_playercolortable = {	"@color:15,64,255",
		"@color:226,0,0",
		"@color:235,255,53",
		"@color:0,235,209",
		"@color:252,164,39",
		"@color:178,2,255",
		"@color:255,79,200",
		"@color:115,209,65",
		"@color:0,140,2",
		"@color:184,184,184",
		"@color:184,182,90",
		"@color:136,136,136",
		"@color:230,230,230",
		"@color:57,57,57",
		"@color:139,232,255",
		"@color:255,150,214",
		Blau = "@color:15,64,255",
		Rot =		"@color:226,0,0",
		Gelb =		"@color:235,255,53",
		Tuerkis =	"@color:0,235,209",
		Orange =	"@color:252,164,39",
		Lila =		"@color:178,2,255",
		Pink =		"@color:255,79,200",
		Hellgruen =	"@color:115,209,65",
		Dunkelgruen =	"@color:0,140,2",
		Hellgrau =	"@color:184,184,184",
		Beige	 =	"@color:184,182,90",
		Dunkelgrau =	"@color:136,136,136",
		Weiss =		"@color:230,230,230",
		Schwarz =	"@color:57,57,57",
		Himmelblau =	"@color:139,232,255",
		Hellrosa =	"@color:255,150,214"}

	-- *** Mini Comforts ***
	FanfareSound = function()
	  Sound.PlayGUISound( Sounds.fanfare, 127 )
	end
	KerberosSound = function()
	  Sound.PlayGUISound( Sounds.OnKlick_Select_kerberos, 127 )
	end
	HeliasSound = function()
	  Sound.PlayGUISound( Sounds.OnKlick_Select_helias, 127 )
	end

	Mission_InitLocalResources = function()
		--Add Players Resources
		local i
		for i=1,8 do
			if mpc_MultiplayerPlaying[i] then
				Tools.GiveResouces(i, g_MC_StR.Gold , g_MC_StR.Clay, g_MC_StR.Wood, g_MC_StR.Stone, g_MC_StR.Iron, g_MC_StR.Sulfur)
			end
		end
	end

	MapVersion_InitMapInfoButton = function( _text)
		if type(_text) == "string" then
			XGUIEng.SetText( "TopMainMenuTextButton", "@color:0,0,0,0: ....... @color:255,255,255 Menü @cr @cr ".._text)
		else
			XGUIEng.SetText( "TopMainMenuTextButton", "@color:0,0,0,0: ....... @color:255,255,255 Menü @cr @cr Hier die Mapversion und sonstige Infos einfgen")
		end
	end

	Mauern_und_Tore_Erfassen = function()
		for _pId=0,8 do
			Comfort_TrackEntityIni(_pId,Entities.XD_WallStraight)
			Comfort_TrackEntityIni(_pId,Entities.XD_DarkWallStraight)
			Comfort_TrackEntityIni(_pId,Entities.XD_DarkWallCorner)
			Comfort_TrackEntityIni(_pId,Entities.XD_WallStraightGate_Closed)
			Comfort_TrackEntityIni(_pId,Entities.XD_DarkWallStraightGate_Closed)
			Comfort_TrackEntityIni(_pId,Entities.XD_PalisadeGate1)
			-- Allen Mauern die ID 0 zuweisen
			for i = 1, table.getn( Track_Entity_Table[_pId][Entities.XD_DarkWallStraight] ) do
				local _orientation = Logic.GetEntityOrientation(Track_Entity_Table[_pId][Entities.XD_DarkWallStraight][1])
				local _pos = GetPosition(Track_Entity_Table[_pId][Entities.XD_DarkWallStraight][1])
				DestroyEntity( Track_Entity_Table[_pId][Entities.XD_DarkWallStraight][1] )
				Logic.CreateEntity( Entities.XD_DarkWallStraight, _pos.X, _pos.Y, _orientation, 0 )
			end
			for i = 1, table.getn( Track_Entity_Table[_pId][Entities.XD_DarkWallCorner] ) do
				local _orientation = Logic.GetEntityOrientation(Track_Entity_Table[_pId][Entities.XD_DarkWallCorner][1])
				local _pos = GetPosition(Track_Entity_Table[_pId][Entities.XD_DarkWallCorner][1])
				DestroyEntity( Track_Entity_Table[_pId][Entities.XD_DarkWallCorner][1] )
				Logic.CreateEntity( Entities.XD_DarkWallCorner, _pos.X, _pos.Y, _orientation, 0 )
			end
			for i = 1, table.getn( Track_Entity_Table[_pId][Entities.XD_WallStraight] ) do
				local _orientation = Logic.GetEntityOrientation(Track_Entity_Table[_pId][Entities.XD_WallStraight][1])
				local _pos = GetPosition(Track_Entity_Table[_pId][Entities.XD_WallStraight][1])
				DestroyEntity( Track_Entity_Table[_pId][Entities.XD_WallStraight][1] )
				Logic.CreateEntity( Entities.XD_WallStraight, _pos.X, _pos.Y, _orientation, 0 )
			end
			-- Allen Toren die ID 0 zuweisen und im gvBlocking-Table erfassen
			for i = 1, table.getn( Track_Entity_Table[_pId][Entities.XD_WallStraightGate_Closed] ) do
				local _orientation = Logic.GetEntityOrientation(Track_Entity_Table[_pId][Entities.XD_WallStraightGate_Closed][1])
				local _pos = GetPosition(Track_Entity_Table[_pId][Entities.XD_WallStraightGate_Closed][1])
				DestroyEntity( Track_Entity_Table[_pId][Entities.XD_WallStraightGate_Closed][1] )
				table.insert( gvBlocking, Logic.CreateEntity( Entities.XD_WallStraightGate_Closed, _pos.X, _pos.Y, _orientation, 0 ) )
			end	
			for i = 1, table.getn( Track_Entity_Table[_pId][Entities.XD_DarkWallStraightGate_Closed] ) do
				local _orientation = Logic.GetEntityOrientation(Track_Entity_Table[_pId][Entities.XD_DarkWallStraightGate_Closed][1])
				local _pos = GetPosition(Track_Entity_Table[_pId][Entities.XD_DarkWallStraightGate_Closed][1])
				DestroyEntity( Track_Entity_Table[_pId][Entities.XD_DarkWallStraightGate_Closed][1] )
				table.insert( gvBlocking, Logic.CreateEntity( Entities.XD_DarkWallStraightGate_Closed, _pos.X, _pos.Y, _orientation, 0 ) )
			end	
			-- Allen Toren die ID 0 zuweisen und im gvBlocking-Table erfassen
			for i = 1, table.getn( Track_Entity_Table[_pId][Entities.XD_PalisadeGate1] ) do
				local _orientation = Logic.GetEntityOrientation(Track_Entity_Table[_pId][Entities.XD_PalisadeGate1][i])
				local _pos = GetPosition(Track_Entity_Table[_pId][Entities.XD_PalisadeGate1][i])
				DestroyEntity( Track_Entity_Table[_pId][Entities.XD_PalisadeGate1][i] )
				table.insert( gvBlocking, Logic.CreateEntity( Entities.XD_PalisadeGate1, _pos.X, _pos.Y, _orientation, 0 ) )
			end				
		end
	end
	Winkel = function(_Pos1,_Pos2)
		local delta_X = 0;
		local delta_Y = 0;
		local alpha   = 0
		if type (_Pos1) == "string" or type (_Pos1) == "number" then
			_Pos1 = GetPosition(GetEntityId(_Pos1));
		end
		if type (_Pos2) == "string" or type (_Pos2) == "number" then
			_Pos2 = GetPosition(GetEntityId(_Pos2));
		end
		delta_X = _Pos1.X - _Pos2.X
		delta_Y = _Pos1.Y - _Pos2.Y
		if delta_X == 0 and delta_Y == 0 then -- Gleicher Punkt
			return 0
		end
		alpha = math.deg(math.asin(math.abs(delta_X)/(math.sqrt(__pow(delta_X, 2)+__pow(delta_Y, 2)))))
		if delta_X >= 0 and delta_Y > 0 then
			alpha = 270 - alpha 
		elseif delta_X < 0 and delta_Y > 0 then
			alpha = 270 + alpha
		elseif delta_X < 0 and delta_Y <= 0 then
			alpha = 90  - alpha
		elseif delta_X >= 0 and delta_Y <= 0 then
			alpha = 90  + alpha
		end
		return alpha
	end	
	GetDistance = function(_a, _b)
		if type(_a) ~= "table" then
			_a = GetPosition(_a); 
		end
		if type(_b) ~= "table" then
			_b = GetPosition(_b); 
		end
		return math.sqrt((_a.X - _b.X)^2+(_a.Y - _b.Y)^2)
	end
	CreateWallsFromTo = function(_pos1,_pos2,_pId,_selfcreated)
		if _pId == 0 then _selfcreated = false end
		Logic.CreateEntity( Entities.XD_WallCorner, _pos1.X, _pos1.Y, 0, _pId )
		Logic.CreateEntity( Entities.XD_WallCorner, _pos2.X, _pos2.Y, 0, _pId )
		local _Winkel = Winkel(_pos1,_pos2)
		local _Rotation = _Winkel + 90
		if _Rotation > 360 then _Rotation = _Rotation - 360 end
		local _XStep = math.cos(_Winkel/360*math.pi*2) * 200
		local _YStep = math.sin(_Winkel/360*math.pi*2) * 200
		_CurrentWallPos = {X = _pos1.X+_XStep,Y = _pos1.Y+_YStep}
		_visible = true
		local _eId = 0
		while math.floor(Winkel(_CurrentWallPos,_pos2)) == math.floor(_Winkel) and GetDistance(_CurrentWallPos,_pos2) > 200 do

			if _visible then			
				_eId = Logic.CreateEntity( Entities.XD_WallStraight, _CurrentWallPos.X, _CurrentWallPos.Y, _Rotation, _pId )
				if _selfcreated then
					SelfCreatedWalls[_pId][_eId] = {}
					SelfCreatedWalls[_pId][_eId].ID = _eId
					SelfCreatedWalls[_pId][_eId].SellTributCallback = function()
						local _pos = GetPosition(_eId)
						DestroyEntity(SelfCreatedWalls[_pId][_eId].ID)
						Logic.CreateEffect( GGL_Effects.FXBuildingSmoke, _pos.X, _pos.Y, _pId );
					end
					SelfCreatedWalls[_pId][_eId].SellTributID = AddTribute( CreateATribute(8, "", { Gold = 0}, SelfCreatedWalls[_pId][_eId].SellTributCallback ) )	
					SelfCreatedWalls[_pId][_eId].Pfosten = 0
					MakeInvulnerable(_eId)
				end				
			else
				if _selfcreated then
					SelfCreatedWalls[_pId][_eId].Pfosten = Logic.CreateEntity( Entities.XD_WallCorner, _CurrentWallPos.X, _CurrentWallPos.Y, _Rotation, _pId )
					MakeInvulnerable(SelfCreatedWalls[_pId][_eId].Pfosten)					
				else
					Logic.CreateEntity( Entities.XD_WallCorner, _CurrentWallPos.X, _CurrentWallPos.Y, _Rotation, _pId )
				end
			end
			_visible = not _visible
			_CurrentWallPos = {X = _CurrentWallPos.X+_XStep,Y = _CurrentWallPos.Y+_YStep}			
		end
		_CurrentWallPos = {X = _pos2.X-_XStep,Y = _pos2.Y-_YStep}
		Logic.CreateEntity( Entities.XD_WallStraight, _CurrentWallPos.X, _CurrentWallPos.Y, _Rotation, _pId )
	end	

	function Umlaute( _text )
		local texttype = type( _text );
		if texttype == "string" then
			_text = string.gsub( _text, "", "\195\164" );
			_text = string.gsub( _text, "", "\195\182" );
			_text = string.gsub( _text, "", "\195\188" );
			_text = string.gsub( _text, "", "\195\159" );
			_text = string.gsub( _text, "", "\195\132" );
			_text = string.gsub( _text, "", "\195\150" );
			_text = string.gsub( _text, "", "\195\156" );
			return _text;
		elseif texttype == "table" then
			for k,v in _text do
				_text[k] = Umlaute( v );
			end
			return _text;
		else
			return _text;
		end 
	end
	 
	function AutoUmlaut()
		StartBriefingUmlauteOrig = StartBriefing;
		StartBriefing = function( _briefing )
			StartBriefingUmlauteOrig( Umlaute( _briefing ) );
		end
		 
		CreateNPCUmlauteOrig = CreateNPC;
		CreateNPC = function( _npc )
			CreateNPCUmlauteOrig( Umlaute( _npc ) );
		end
		 
		MessageUmlauteOrig = Message;
		Message = function( _text )
			MessageUmlauteOrig( Umlaute( tostring( _text ) ) );
		end 
		XGUIEng.SetTextOrig = XGUIEng.SetText;
		XGUIEng.SetText = function(_a,_text)
			XGUIEng.SetTextOrig(_a, Umlaute( tostring( _text ) ))
		end
	end

	AutoUmlaut()
	
	function CreateArmyTroops( _player, _position, _leaderType, _numberOfSoldiers, _troops, _experience, _move )
		local army = {
			player     = _player,
		}
		local tD  = {
			maxNumberOfSoldiers = _numberOfSoldiers,
			minNumberOfSoldiers = 0,
			experiencePoints    = _experience,
			leaderType          = _leaderType,
			position            = _position,
		}
		for i = 1,_troops do
			army[i] = CreateTroop( army , tD )
		end
		if _move ~= nil then
			for i = 1,_troops do
				Move( army[i], _move)
			end
		end
	 
	end 	
	--CreateArmyTroops( 1, {X= 9000,Y=13000}	, Entities.PU_LeaderRifle1, 4, 1, 0, {X= 9000,Y=13000}	 )
end

function MovieFensterTooltip()
	-- aus ItM by Noigi
	MovieFenster = function( _title, _text, _WPinternal )
		if gvWP then
			if _WPinternal then -- MovieFenster wird vom Itm-Skript aufgerufen
				gvWP.MF.internalUse = true;
				MovieFensterCore( _title, _text );
			else -- ... vom Mapper
				gvWP.MF.externalUse = true;
				gvWP.MF.BACKUPextTitle = _title;
				gvWP.MF.BACKUPextText = _text;
				if not gvWP.MF.internalUse then
					MovieFensterCore( _title, _text );
				end
			end
		else
			MovieFensterCore( _title, _text );
		end
	end

	MovieFensterCore = function( _title, _text )
		XGUIEng.ShowWidget( "Movie", 1 );
		XGUIEng.ShowWidget( "Cinematic_Text", 0 );
		XGUIEng.ShowWidget( "MovieBarTop", 0 );
		XGUIEng.ShowWidget( "MovieBarBottom", 0 );
		XGUIEng.ShowWidget( "MovieInvisibleClickCatcher", 0 );
		XGUIEng.ShowWidget( "CreditsWindowLogo", 0 );
		XGUIEng.SetText( "CreditsWindowTextTitle", _title );
		XGUIEng.SetText( "CreditsWindowText", _text );
	end

	HideMovieFenster = function( _WPinternal )
		if gvWP then
			if _WPinternal then -- HideMovieFenster wird vom Itm-Skript aufgerufen
				gvWP.MF.internalUse = false;
				if gvWP.MF.externalUse then
					MovieFensterCore( gvWP.MF.BACKUPextTitle, gvWP.MF.BACKUPextText );
				else
					HideMovieFensterCore();
				end
			else -- ... vom Mapper
				gvWP.MF.externalUse = false;
				if not gvWP.MF.internalUse then
					HideMovieFensterCore();
				end
			end
		else
			HideMovieFensterCore();
		end
	end

	HideMovieFensterCore = function()
		XGUIEng.ShowWidget( "Movie", 0 );
	end

	WPUpdateFeedback = function()
	end

end


-- *******************************************************************
-- **************  RulesetAuswahl Comfortfunktion          ***********
-- **************  Author: Anarki                          ***********
-- **************  Support: www.dedk.de / www.dedk.de/wiki ***********
-- *******************************************************************

function MPC_Initialize()
	-- Besserer Zoom
	Camera.ZoomSetFactorMax(2)
	
	GameStartStarted = true
	-- um error bei ID0 zu vermeiden
	Score.Player[0] = {} 
	Score.Player[0]["buildings"] = 0
	Score.Player[0]["all"] = 0
	-- Alles Tracken was im MPComfort bentigt wird
	for _pId = 1,8 do
		-- HQs
		for i = 1,table.getn(gv_Entities_HQs) do
			Comfort_TrackEntityIni(_pId,gv_Entities_HQs[i])
		end
		-- Trme
		for i = 1, table.getn(gv_Entities_Tuerme) do
			Comfort_TrackEntityIni(_pId,gv_Entities_Tuerme[i])
		end	
		-- DZs
		for i = 1, table.getn(gv_Entities_Dorfzentren) do
			Comfort_TrackEntityIni(_pId,gv_Entities_Dorfzentren[i])		
		end
	end

	-- Regelanzeige Job
	MPC_Regelanzeige = function()
		if mpc_GameStartDelay > 0 or XGUIEng.IsModifierPressed(Keys.ModifierAlt) == 1 then
			g_MC_RulesTextForDisplay = ""
			
			if not(GameStartStarted) then
				local GameStartCounterColor
				if mpc_GameStartDelay > -1 then GameStartCounterColor = gvCol.rot end
				if mpc_GameStartDelay > 5 then GameStartCounterColor = gvCol.gelb end
				if mpc_GameStartDelay > 10 then GameStartCounterColor = gvCol.gruen end
				
				g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.weiss.." "..g_MC_Loc[lang].GameStarts.." "
				if mpc_Rules.FastGame[1] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.gelb.." "..g_MC_Loc[lang].AsFastGame.." "..gvCol.weiss end
				g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." in "..GameStartCounterColor.." "..mpc_GameStartDelay.." "..g_MC_Loc[lang].Seconds.." @cr @cr "
			end
			
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["WS"].Name..": "..gvCol.orange.." "..mpc_Rules["WS"][mpc_Rules["WS"].Cur].." - "
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["Playermode"].Name..": "..gvCol.orange.." "..mpc_Rules["Playermode"][mpc_Rules["Playermode"].Cur].." @cr "
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["Weathermin"].Name..": "..gvCol.orange.." "..mpc_Rules["Weathermin"][mpc_Rules["Weathermin"].Cur].." / "..CountdownGetTick(WeatherChangeLimitCountdownID).." @cr "
						
			if mpc_Rules["FlagActive"].Act[1] then
				g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["FlagActive"].Name..": @cr "
				if CtF_HoldTimer >= 0 then
					g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["FlagActive"].FlagHolder..": "..gvCol.orange.." Team"..mpc_playerteams[CtF_FlaggenhalterpId].." "..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["FlagActive"].Timer..": "..gvCol.orange.." "..CtF_HoldTimer.." @cr "
				end
				local _teams = {}
				local _teamtracked = false
				for _pId = 1,8 do
					if not(mpc_playernames[_pId] == "") then
						_teamtracked = false
						for i=1, table.getn(_teams) do
							if mpc_playerteams[_pId] == _teams[i] then
								_teamtracked = true
								break
							end
						end
						if not(_teamtracked) then
							table.insert(_teams, mpc_playerteams[_pId])
							g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.orange.." Team"..mpc_playerteams[_pId]..": "..gvCol.gelb.." "..CtF_Punkte[_pId].." / "..gvCol.gruen.." "..mpc_Rules["FlagPoints"][mpc_Rules["FlagPoints"].Cur].." @cr "
						end
					end
				end
			end
			
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["MaxHeroes"].Name..": "..gvCol.orange.." "..mpc_Rules.MaxHeroes[mpc_Rules.MaxHeroes.Cur].." - "
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["Maxtowers"].Name..": "..gvCol.orange.." "..mpc_Rules["Maxtowers"][mpc_Rules["Maxtowers"].Cur].." @cr "
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["TradeLimit"].Name..": "..gvCol.orange.." "..mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur].." @cr "

			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].Rule["Special1"].Name.." "..gvCol.orange
			-- Regenset String:
			if mpc_Rules["Special1"].Act[1] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special1"][1]; end
			if mpc_Rules["Special1"].Act[2] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special1"][2]; end
			if mpc_Rules["Special1"].Act[4] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special1"][4]; 
			elseif mpc_Rules["Special1"].Act[3] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special1"][3];
			end		
			if mpc_Rules["Special1"].Act[5] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special1"][5]; end
			if mpc_Rules["Special1"].Act[6] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special1"][6]; end
			if mpc_Rules["Special2"].Act[1] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special2"][1]; end
			if mpc_Rules["Special2"].Act[2] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special2"][2]; end
			if mpc_Rules["Special2"].Act[3] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special2"][3]; end
			if mpc_Rules["Special2"].Act[4] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special2"][4]; end
			if mpc_Rules["Special2"].Act[5] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special2"][5]; end
			if mpc_Rules["Special2"].Act[6] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Special2"][6]; end
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." @cr "
			
			
			
			
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay..gvCol.tuerkis.." "..g_MC_Loc[lang].ForbittenUnits..": "..gvCol.orange
			-- Regenset String:
			for i = 1, table.getn(mpc_Rules["Units1"].Act) do
				if not mpc_Rules["Units1"].Act[i] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Units1"][i]; end
			end
			
			if not mpc_Rules["Buildings1"].Act[2] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Buildings1"][2]; end
			if not mpc_Rules["Buildings1"].Act[1] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Buildings1"][1]; end
			if not mpc_Rules["Buildings1"].Act[3] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Buildings1"][3]; end
			if not mpc_Rules["Weather"].Act[1] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Weather"][1]; end
			if not mpc_Rules["Weather"].Act[2] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Weather"][2]; end
			if not mpc_Rules["Weather"].Act[3] then g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Weather"][3]; end
			for i = 1,12 do
				if not (mpc_Rules["Heroes"].Act[i] == true) then
					g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." "..g_MC_Loc[lang].Rule["Heroes"][i];
				end
			end
			g_MC_RulesTextForDisplay = g_MC_RulesTextForDisplay.." @cr "
			MovieFenster(gvCol.space..": ....... "..gvCol.beige.." "..g_MC_Loc[lang].Rules.." ",g_MC_RulesTextForDisplay,true);
		else
			HideMovieFenster(true)
		end
	end
		
	MPC_Start = function()
		
		-- Spieler zur Regelwahl wird bestimmt
		setuppId = 1
		for i = 1,9 do
			if i == 9 then
				setuppId = 1
				break			
			end
			if not(mpc_playernames[i] == "") then
				setuppId = i
				break
			end
		end
		for _pId=1,8 do
			ForbidTechnology(Technologies.T_MakeSnow, _pId);
			ForbidTechnology(Technologies.B_Bridge, _pId);
		end		
		-- Alle Einheiten erstmal unspielbar setzen
		Logic.SuspendAllEntities()
		
		-- Bentigt fr Multichoice Regeln
		mpc_CurStep = {}
	
		mpc_CurRule = 1
		mpc_VillageCenterTimer = {}
		mpc_Rules = {}

		mpc_Rules["DorfzentrumLvL"] = 1

		mpc_Rules["MapSpecial"] = {}
		mpc_Rules["MapSpecial"].Act = {}
		mpc_Rules["MapSpecial"].Sel = {}	
		mpc_Rules["MapSpecial"].Name = {}
		
		mpc_Rules["WS"] = {0, 5, 10, 15, 20, 30, 40, 60, 90}
		mpc_Rules["WS"].Cur = 6
		mpc_Rules["WS"].Sel = true	

		mpc_Rules["MaxHeroes"] = {0,1,2,3,4,5,6,7,8,9,10,11,12}
		mpc_Rules["MaxHeroes"].Cur = 3
		mpc_Rules["MaxHeroes"].Sel = true	

		mpc_Rules["TradeLimit"] = {"Deaktiviert",1000,2000,3000,4000,5000,6000,7000,8000,9000,10000,15000}
		mpc_Rules["TradeLimit"].Cur = 4
		mpc_Rules["TradeLimit"].Sel = true	

		mpc_Rules["Playermode"] = {"1v1","2v1","2v2","2v3","3v3","3v4","4v4"}	
		mpc_Rules["Playermode"].Cur = 3
		mpc_Rules["Playermode"].Sel = true

		mpc_Rules["Weathermin"] = {0,1,1.5,2,3,5,10}	
		mpc_Rules["Weathermin"].Cur = 1
		mpc_Rules["Weathermin"].Sel = true

		mpc_Rules["Maxtowers"] = {0,1,2,3,5,7,10,15,20}		
		mpc_Rules["Maxtowers"].Cur = 4
		mpc_Rules["Maxtowers"].Sel = true
		
		-- CtF Einstellungen
		---- CtF Aktivieren / HQ unzerstrbar
		mpc_Rules["FlagActive"] = {}
		mpc_Rules["FlagActive"].Act = {false, true}
		mpc_Rules["FlagActive"].Sel = {true, true}
		
		---- Wie nah muss man an die Flagge
		mpc_Rules["FlagPoints"] = {1,3,5,7,10,15}
		mpc_Rules["FlagPoints"].Cur = 3
		mpc_Rules["FlagPoints"].Sel = true
		
		---- Maximale Haltezeit
		mpc_Rules["FlagMaxHoldtime"] = {1,1.5,2,2.5,3,4,5,10}
		mpc_Rules["FlagMaxHoldtime"].Cur = 5
		mpc_Rules["FlagMaxHoldtime"].Sel = true
		
		---- Wie nah muss man an die Flagge
		mpc_Rules["FlagRange"] = {}
		mpc_Rules["FlagRange"].Flag = 300
		mpc_Rules["FlagRange"].Dest = 1250
		
		mpc_Rules["Units1"] = {}
		mpc_Rules["Units1"].Act = {true, true, true, true, true, true}
		mpc_Rules["Units1"].Sel = {true, true, true, true, true, true}

		mpc_Rules["Buildings1"] = {}
		mpc_Rules["Buildings1"].Act = {true, true, true, true, true, true}
		mpc_Rules["Buildings1"].Sel = {true, true, true, true, true, true}

		mpc_Rules["Weather"] = {}
		mpc_Rules["Weather"].Act = {true, true, true}
		mpc_Rules["Weather"].Sel = {true, true, true}
		
		mpc_Rules["Special1"] = {}	
		mpc_Rules["Special1"].Act = {true, true, true, true, true, false} -- Default Specials
		mpc_Rules["Special1"].Sel = {true, true, true, true, true, true} -- Auswaehlbare Specials
		mpc_Rules["Special1"].TimeBetweenBlessings = 60

		mpc_Rules["Special2"] = {}	
		mpc_Rules["Special2"].Act = {true, false, false, false,true,false} -- Default Specials
		mpc_Rules["Special2"].Sel = {true, true, true, true,true,false} -- Auswaehlbare Specials

		
		mpc_Rules.HQInv = {false, false, false, false, false, false, false, false}
		mpc_Rules.BlessTimer = {}
		for i = 1,8 do
			mpc_Rules.BlessTimer[i] = {}
			mpc_Rules.BlessTimer[i][1] = -1 * mpc_Rules["Special1"].TimeBetweenBlessings
			mpc_Rules.BlessTimer[i][2] = -1 * mpc_Rules["Special1"].TimeBetweenBlessings
			mpc_Rules.BlessTimer[i][3] = -1 * mpc_Rules["Special1"].TimeBetweenBlessings
			mpc_Rules.BlessTimer[i][4] = -1 * mpc_Rules["Special1"].TimeBetweenBlessings
			mpc_Rules.BlessTimer[i][5] = -1 * mpc_Rules["Special1"].TimeBetweenBlessings			
		end	
		
		mpc_Rules["Heroes"] = {}	
		mpc_Rules["Heroes"].Act = {true, true, true, true, true, true, true, true, true, true, true, true}
		mpc_Rules["Heroes"].Sel = {true, true, true, true, true, true, true, true, true, true, true, true}


		mpc_Rules.FastGame = {false}
		mpc_Rules.FastGame.Multiplicator = 2
		mpc_Rules.FastGame.Sel = true
		
		mpc_GameStartDelay = 10
		gvStartJobID = 0
		
		g_MC_StR = { Gold = 500,
						Clay = 1500,
						Wood = 1200,
						Stone = 1000,
						Iron = 0,
						Sulfur = 0 }
		
		mpc_Rules.lang = {}
		mpc_Rules.lang.TribId = {0,0,0,0,0,0,0,0}
		mpc_Rules.lang.notSel = {g_MC_Loc.Lang.notSel[1], g_MC_Loc.Lang.notSel[2], g_MC_Loc.Lang.notSel[3]}
		mpc_Rules.lang.Sel = {g_MC_Loc.Lang.Sel[1],g_MC_Loc.Lang.Sel[2],g_MC_Loc.Lang.Sel[3]}
		mpc_Rules.lang.Cur = {2,2,2,2,2,2,2,2}
		lang = 1
		for i = 1, 8 do 
			if not(i==setuppId) then mpc_CreateLanguageChoiceTributes(i) end
		end
		for i = 1,12 do
			GUIAction_ToggleMenu("BuyHeroWindowBuyHero"..i, 0)
		end
		StartSimpleHiResJob("MPC_Regelanzeige")
		
		--mpc_Rules.random = {}
		--mpc_Rules.random.Sel = true
		--mpc_Rules.random["WS"] = {0.03,0.13,0.93,0.98,1.00}
		--mpc_Rules.random.MaxHeroes = {0.25,0.4,0.7,0.9,0.98,0.99,1.00}
		--mpc_Rules.random[1] = {0.6, 0.3, 0.6, 0.6, 0.1, 0.3}
		--mpc_Rules.random[2] = {0.9, 0.75, 0.5}
		--mpc_Rules.random[3] = {0.2, 0.2, 0.2}
		--mpc_Rules.random[4] = {0, 0.03, 0.15,0.4,0.07}
		--mpc_Rules.random[5] = {}
		--mpc_Rules.random[6] = {0.1, 0.1, 0.25,0.1,0.1,0.25,0.25,0.1,0.2,0.25,0.1,0.1}	
			
		mpc_Rules.statisticLog = true
		gv_MC_imdead = {}
		gv_MC_NoDZReplaceJob = 0
		gv_MC_NoDZReplaceTimer = 0
		Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "ActionOnEntityCreated", 1)
		Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_DESTROYED, "", "ActionOnEntityDestroyed", 1)
		ClearAllPlayerVillageCenters()
	end
   	
	mpc_TRIB_SelectSingleChoiceRule = function (_step, _rule)
		if mpc_Rules[_rule].Sel then
			local _countRules = table.getn( mpc_Rules[_rule] )	
			mpc_Rules[_rule].Cur = mpc_Rules[_rule].Cur + 1; 
			if mpc_Rules[_rule].Cur > _countRules then 
				mpc_Rules[_rule].Cur = 1 
			end
		end
		RulesetChoosen(_step)			
	end
	
	mpc_TRIB_SelectLangChoiceRule = function (_player)
		local _pId = _player
		if _player == 9 then _player = setuppId end
		local _countRules = table.getn( mpc_Rules.lang.Sel )	
		mpc_Rules.lang.Cur[_player] = mpc_Rules.lang.Cur[_player] + 1; 
		if mpc_Rules.lang.Cur[_player] > _countRules then 
			mpc_Rules.lang.Cur[_player] = 1
		end
		if gv_guipId == _player then lang = mpc_Rules.lang.Cur[_player] - 1 end
		if _pId < 9 then
			LangChoosen(_pId)
		else
			RulesetChoosen(99)
		end
	end
	
	mpc_TRIB_SelectRule = function(_step,_rule)
		mpc_CurRule = _rule
		local _countRules = table.getn(mpc_Rules[_rule].Act)
		while true do			
			mpc_CurStep[_rule] = mpc_CurStep[_rule] + 1; 
			if mpc_CurStep[_rule] > _countRules then 
				mpc_CurStep[_rule] = 1 
				break
			end
			if mpc_Rules[_rule].Sel[mpc_CurStep[_rule]] == true then
				break
			end
		end
		RulesetChoosen(_step)
	end
		
	mpc_TRIB_ChangeRule = function(_step)		
		if mpc_Rules[mpc_CurRule].Sel[mpc_CurStep[mpc_CurRule]] then 
			mpc_Rules[mpc_CurRule].Act[ mpc_CurStep[mpc_CurRule] ] = not( mpc_Rules[mpc_CurRule].Act[ mpc_CurStep[mpc_CurRule] ] ) 
		end 
		RulesetChoosen(_step)
	end
	
	mpc_TRIB_Setup = function()
		mpc_TRIB = {}
		LangChoosen = function(_player) mpc_CreateLanguageChoiceTributes(_player) end
		
		RemoveAllmpc_TRIB = function() for i = 1,6 do Logic.RemoveTribute( setuppId, mpc_TRIB[i]); end end
		
		RulesetChoosen = function(_NextStep) RemoveAllmpc_TRIB(); SetupRuleSets(_NextStep) end
		
		mpc_StepFunc = {}
		mpc_StepFunc[99]= {}
		mpc_StepFunc[99][1] = function() RulesetChoosen(99) end
		mpc_StepFunc[99][3] = function() 
				RemoveAllmpc_TRIB()
				setuppId = setuppId + 1
				for i = setuppId,9 do
					if i == 9 then
						for u = 1,9 do
							if not(mpc_playernames[u] == "") then
								setuppId = u
								Message(mpc_playernames[setuppId].." kann jetzt die Regeln einstellen")
								break
							end						
						end
						break			
					end
					if not(mpc_playernames[i] == "") then
						setuppId = i
						Message(mpc_playernames[setuppId].." kann jetzt die Regeln einstellen")
						break
					end
				end
				SetupRuleSets(99) 
			end
		mpc_StepFunc[99][6] = function() RulesetChoosen(0) end

		mpc_TRIBRuleFunc = {}
		mpc_TRIBRuleFunc.lang = {}
		for i = 1,9 do
			local _i = i
			mpc_TRIBRuleFunc.lang[_i] = function() mpc_TRIB_SelectLangChoiceRule(_i) end
		end	
		mpc_TRIBRuleFunc["WS"] = function() mpc_TRIB_SelectSingleChoiceRule(1, "WS") end 
		mpc_TRIBRuleFunc["MaxHeroes"] = function() mpc_TRIB_SelectSingleChoiceRule(1, "MaxHeroes") end	
		mpc_TRIBRuleFunc["Heroes"] = function() mpc_TRIB_SelectRule(1,"Heroes") end
		mpc_TRIBRuleFunc["Buildings1"] = function() mpc_TRIB_SelectRule(1,"Buildings1") end
		
		mpc_TRIBRuleFunc["TradeLimit"] = function() mpc_TRIB_SelectSingleChoiceRule(2, "TradeLimit") end	
		mpc_TRIBRuleFunc["Units1"] = function() mpc_TRIB_SelectRule(2,"Units1") end	
		mpc_TRIBRuleFunc["Weather"] = function() mpc_TRIB_SelectRule(2,"Weather") end
		mpc_TRIBRuleFunc["Special1"] = function() mpc_TRIB_SelectRule(2,"Special1") end
		
		mpc_TRIBRuleFunc["Playermode"] = function() mpc_TRIB_SelectSingleChoiceRule(3, "Playermode") end 
		mpc_TRIBRuleFunc["Weathermin"] = function() mpc_TRIB_SelectSingleChoiceRule(3, "Weathermin") end 
		mpc_TRIBRuleFunc["Maxtowers"] = function() mpc_TRIB_SelectSingleChoiceRule(3, "Maxtowers") end 
		mpc_TRIBRuleFunc["Special2"] = function() mpc_TRIB_SelectRule(3,"Special2") end

		mpc_TRIBRuleFunc["FlagActive"] = function() mpc_TRIB_SelectRule(4, "FlagActive") end 
		mpc_TRIBRuleFunc["FlagPoints"] = function() mpc_TRIB_SelectSingleChoiceRule(4, "FlagPoints") end 
		mpc_TRIBRuleFunc["FlagMaxHoldtime"] = function() mpc_TRIB_SelectSingleChoiceRule(4, "FlagMaxHoldtime") end 
		mpc_TRIBRuleFunc["FlagRange"] = function() mpc_TRIB_SelectSingleChoiceRule(4,"FlagRange") end
		
		mpc_TRIBRuleFunc["MapSpecial"] = function() mpc_TRIB_SelectRule(98,"MapSpecial") end

		mpc_TRIBChangeRuleFunc = {}
		for i = 1,100 do
			local _i = i
			mpc_TRIBChangeRuleFunc[_i] = function() mpc_TRIB_ChangeRule(_i) end
		end
		
		mpc_TRIBGoOn = {}
		mpc_TRIBGoOn[1] = function() mpc_CurRule = "Units1"; RulesetChoosen(2) end 
		mpc_TRIBGoOn[2] = function() RulesetChoosen(3) end
		mpc_TRIBGoOn[3] = function() RulesetChoosen(4) end
		mpc_TRIBGoOn[4] = function() mpc_CurRule = "MapSpecial"; RulesetChoosen(98) end
		mpc_TRIBGoOn[5] = function() RulesetChoosen(6) end
		mpc_TRIBGoOn[99] = function()  mpc_CurRule = "Heroes"; RulesetChoosen(1) end
		
		mpc_StepFunc[98] = {}
		mpc_StepFunc[98][1] = function() RulesetChoosen(0) end
		mpc_StepFunc[98][2] = function() RulesetChoosen(99) end
		mpc_StepFunc[98][3] = function() mpc_Rules.FastGame[1] = true; RulesetChoosen(0) end
		mpc_StepFunc[98][4] = function() RulesetChoosen(98) end
	end
		
	mpc_CreateChoiceTributes = function(_rule)
		local _countRules = table.getn(mpc_Rules[_rule].Act)
		local Color
		local _text = "@color:255,255,255 "..g_MC_Loc[lang].Rule[_rule].Name..": "
		for i = 1, _countRules do
			if mpc_Rules[_rule].Sel[i] then
				if mpc_CurStep[_rule] == nil then
					mpc_CurStep[_rule] = 1
				end
				if mpc_CurStep[_rule] == i and mpc_CurRule == _rule then
					if mpc_Rules[_rule].Act[i] then Color = "@color:200,255,200 *"
					else Color = "@color:255,200,200 *"
					end
				else
					if mpc_Rules[_rule].Act[i] then Color = "@color:0,255,0 "
					else Color = "@color:255,0,0 "
					end
				end
			else
				if mpc_Rules[_rule].Act[i] then Color = "@color:0,128,0 "
				else Color = "@color:128,0,0 "
				end
			end
			if _rule == "MapSpecial" then
				_text = _text..Color..mpc_Rules["MapSpecial"].Name[i].." - ";
			else
				_text = _text..Color..g_MC_Loc[lang].Rule[_rule][i].." - ";
			end
		end
		return AddTribute( CreateATribute(setuppId, _text, { Gold = 0}, mpc_TRIBRuleFunc[_rule] ) )	
	end

	
	mpc_CreateSingleChoiceTributes = function(_rule)
		local _countRules = table.getn(mpc_Rules[_rule])
		local Color
		local _text = "@color:255,255,255 "..g_MC_Loc[lang].Rule[_rule].Name..": "
        for i = 1, _countRules do
			if mpc_Rules[_rule].Cur == i then Color = "@color:0,255,0 "
			else 
				if mpc_Rules[_rule].Sel then
					Color = "@color:255,0,0 "
				else
					Color = "@color:127,127,127 "
				end
			end
			_text = _text..Color..mpc_Rules[_rule][i].." - ";
		end
		return AddTribute( CreateATribute(setuppId, _text, { Gold = 0}, mpc_TRIBRuleFunc[_rule] ) )
	end	

	mpc_CreateLanguageChoiceTributes = function(_player)
		local _countRules = table.getn(mpc_Rules.lang.Sel)
		local _pId = _player
		local _text = ""
		if _player == 9 then _player = setuppId end
		local _text = ""
        for i = 1, _countRules do
			if mpc_Rules.lang.Cur[_player] == i then _text = _text..gvCol.weiss.." ( "..g_MC_Loc.Lang.Sel[i].." "..gvCol.weiss.." ) - "
			else _text = _text..g_MC_Loc.Lang.notSel[i].." - "
			end
		end		
		return AddTribute( CreateATribute(_player, _text, { Gold = 0}, mpc_TRIBRuleFunc.lang[_pId] ) )	
	end	
	
	SetupRuleSets = function(_Step)	   
	   if _Step == 99 then
			mpc_TRIB[1] = AddTribute( CreateATribute(setuppId, "@color:255,255,0 "..g_MC_Loc[lang].GoOn..":", { Gold = 0}, mpc_TRIBGoOn[_Step] ) )
			mpc_TRIB[2] = mpc_CreateLanguageChoiceTributes(9)
			mpc_TRIB[3] = AddTribute( CreateATribute(setuppId, "Give Rule Setup Next Player", { Gold = 0}, mpc_StepFunc[99][3] ) )
			-- Random Rule Generator erstmal deaktiviert wegen inkompatibiltt
			--mpc_TRIB[3] = AddTribute( CreateATribute(setuppId, "@color:255,255,0 "..g_MC_Loc[lang].Random, { Gold = 0}, mpc_StepFunc[99][3] ) )
			mpc_TRIB[6] = AddTribute( CreateATribute(setuppId, "QUICKSTART", { Gold = 0}, mpc_StepFunc[99][6] ) )
	   end
		   
		if _Step == 1 then
			mpc_TRIB[1] = AddTribute( CreateATribute(setuppId, "@color:255,255,0 "..g_MC_Loc[lang].GoOn..":", { Gold = 0}, mpc_TRIBGoOn[_Step] ) )
			mpc_TRIB[2] = mpc_CreateSingleChoiceTributes("WS")
			mpc_TRIB[3] = mpc_CreateSingleChoiceTributes("MaxHeroes")
			mpc_TRIB[4] = mpc_CreateChoiceTributes("Heroes")
			mpc_TRIB[5] = mpc_CreateChoiceTributes("Buildings1")
			mpc_TRIB[6] = AddTribute( CreateATribute(setuppId, "@color:255,0,255 "..g_MC_Loc[lang].ChangeStatus, { Gold = 0}, mpc_TRIBChangeRuleFunc[_Step] ) )							
		end
		
		if _Step == 2 then
			mpc_TRIB[1] = AddTribute( CreateATribute(setuppId, "@color:255,255,0 "..g_MC_Loc[lang].GoOn..":", { Gold = 0}, mpc_TRIBGoOn[_Step] ) )			
			mpc_TRIB[2] = mpc_CreateSingleChoiceTributes("TradeLimit")
			mpc_TRIB[3] = mpc_CreateChoiceTributes("Units1")
			mpc_TRIB[4] = mpc_CreateChoiceTributes("Weather")
			mpc_TRIB[5] = mpc_CreateChoiceTributes("Special1")
			mpc_TRIB[6] = AddTribute( CreateATribute(setuppId, "@color:255,0,255 "..g_MC_Loc[lang].ChangeStatus, { Gold = 0}, mpc_TRIBChangeRuleFunc[_Step] ) )						
		end

		if _Step == 3 then
			mpc_TRIB[1] = AddTribute( CreateATribute(setuppId, "@color:255,255,0 "..g_MC_Loc[lang].GoOn..":", { Gold = 0}, mpc_TRIBGoOn[_Step] ) )			
			mpc_TRIB[2] = mpc_CreateSingleChoiceTributes("Playermode")
			mpc_TRIB[3] = mpc_CreateSingleChoiceTributes("Weathermin")
			mpc_TRIB[4] = mpc_CreateSingleChoiceTributes("Maxtowers")
			mpc_TRIB[5] = mpc_CreateChoiceTributes("Special2")
			mpc_TRIB[6] = AddTribute( CreateATribute(setuppId, "@color:255,0,255 "..g_MC_Loc[lang].ChangeStatus, { Gold = 0}, mpc_TRIBChangeRuleFunc[_Step] ) )						
		end

		if _Step == 4 then
			mpc_TRIB[1] = AddTribute( CreateATribute(setuppId, "@color:255,255,0 "..g_MC_Loc[lang].GoOn..":", { Gold = 0}, mpc_TRIBGoOn[_Step] ) )					
			mpc_TRIB[2] = mpc_CreateChoiceTributes("FlagActive")
			mpc_TRIB[3] = mpc_CreateSingleChoiceTributes("FlagPoints")
			mpc_TRIB[4] = mpc_CreateSingleChoiceTributes("FlagMaxHoldtime")
			mpc_TRIB[5] = mpc_CreateSingleChoiceTributes("FlagRange")
			mpc_TRIB[6] = AddTribute( CreateATribute(setuppId, "@color:255,0,255 "..g_MC_Loc[lang].ChangeStatus, { Gold = 0}, mpc_TRIBChangeRuleFunc[_Step] ) )						
		end

		if _Step == 98 then
			mpc_TRIB[1] = AddTribute( CreateATribute(setuppId, "@color:0,255,0 "..g_MC_Loc[lang].StartGame, { Gold = 0}, mpc_StepFunc[_Step][1] ) )
			mpc_TRIB[2] = AddTribute( CreateATribute(setuppId, "@color:255,0,0 "..g_MC_Loc[lang].Back, { Gold = 0}, mpc_StepFunc[_Step][2] ) )
			if mpc_Rules.FastGame.Sel then mpc_TRIB[3] = AddTribute( CreateATribute(setuppId, gvCol.gelb.." "..g_MC_Loc[lang].FastGameSelection, { Gold = 0}, mpc_StepFunc[_Step][3] ) ) end
			if table.getn(mpc_Rules["MapSpecial"].Name) > 0 then
				mpc_TRIB[4] = mpc_CreateChoiceTributes("MapSpecial")
				mpc_TRIB[6] = AddTribute( CreateATribute(setuppId, "@color:255,0,255 "..g_MC_Loc[lang].ChangeStatus, { Gold = 0}, mpc_TRIBChangeRuleFunc[_Step] ) )	
			end	
		end
		
		if _Step == 0 then
			local wait = 1
			WaitASecondBeforeMPCStart = function()
				if wait <= 0 then
					mpc_CreateLanguageChoiceTributes(setuppId)
					SpecialMapPlayerModeActions()
					GUIAction_ToggleMenu( "TradeWindow", 0)
					VerifyRulesets()
					return true					
				end
				wait = wait - 1
			end
			StartSimpleHiResJob(WaitASecondBeforeMPCStart)
		end
		
	end
	
	mpc_randomrulegenerator = function()
		local _randomnr
		_randomnr = GetRandom(101) / 100
		for i = 1,6 do
			if _randomnr <= mpc_Rules.random["WS"][i] then
				mpc_Rules["WS"].Cur = i
				break
			end
		end
		_randomnr = GetRandom(101) / 100
		for i = 1,7 do
			if _randomnr <= mpc_Rules.random.MaxHeroes[i] then
				mpc_Rules.MaxHeroes.Cur = i
				break
			end
		end
		for _rule = 1,6 do
			for i = 1, table.getn(mpc_Rules.random[_rule]) do
				_randomnr = GetRandom(101) / 100
				if _randomnr <= mpc_Rules.random[_rule][i] then
					mpc_Rules[_rule].Act[i] = false
				else
					mpc_Rules[_rule].Act[i] = true
				end
			end
		end		

	end
	
	SetupRulesetComfort_Localization = function()
		g_MC_Loc = {}
		g_MC_Loc.Lang = {}
		g_MC_Loc.Lang.notSel = {}
		g_MC_Loc.Lang.notSel[1] = "@color:100,0,0 Eng @color:100,100,100 li @color:0,0,100 sh"
		g_MC_Loc.Lang.notSel[2] = "@color:0,0,0 Deu @color:100,0,0 ts @color:100,100,0 ch"
		g_MC_Loc.Lang.notSel[3] = "@color:100,0,0 Pol @color:100,100,100 ski"
		--g_MC_Loc.Lang.notSel[4] = "@color:100,100,100 @color:0,0,100 ski @color:100,0,0 "
		g_MC_Loc.Lang.Sel = {}
		g_MC_Loc.Lang.Sel[1] = "@color:255,0,0 Eng @color:255,255,255 li @color:0,0,255 sh"
		g_MC_Loc.Lang.Sel[2] = "@color:0,0,0 Deu @color:255,0,0 ts @color:255,255,0 ch"
		g_MC_Loc.Lang.Sel[3] = "@color:255,0,0 Pol @color:255,255,255 ski"
		--g_MC_Loc.Lang.notSel[4] = "@color:100,100,0 Pol @color:100,100,100 ski"
		-- ENGLISH
		g_MC_Loc[0] = {}

		g_MC_Loc[0].Peacetime = "Peacetime"
		g_MC_Loc[0].Wartimemsg = "Lets fight!"
		g_MC_Loc[0].Minutes = "Minutes"
		g_MC_Loc[0].Selected = "Selected!"
		g_MC_Loc[0].GoOn = "Next"
		g_MC_Loc[0].Back = "Back"
		g_MC_Loc[0].Allowed = "allowed"
		g_MC_Loc[0].Forbitten = "forbidden"
		g_MC_Loc[0].ForbittenUnits = "Forbitten as rule"
		g_MC_Loc[0].Yes = "Yes"
		g_MC_Loc[0].No = "No"
		g_MC_Loc[0].StartGame = "Start Game"
		g_MC_Loc[0].GameStarts = "Game Starts"
		g_MC_Loc[0].AsFastGame = "as Fast Game"
		g_MC_Loc[0].In = "in"
		g_MC_Loc[0].Seconds = "Seconds"
		g_MC_Loc[0].ChangeStatus = "Change Status"
		g_MC_Loc[0].Weather = "Weather"
		g_MC_Loc[0].Special = "Special rules"
		g_MC_Loc[0].Buildings = "Buildings"
		g_MC_Loc[0].Units = "Units"
		g_MC_Loc[0].Rules = "Rules"
		g_MC_Loc[0].Activate = "Activate"
		g_MC_Loc[0].Deactivate = "Deactivate"
		g_MC_Loc[0].Deactivated = "Deactivated"
		g_MC_Loc[0].Showrules = "showing rules"
		g_MC_Loc[0].ClericMsg = "clerics are above the laws and will not work overtime"
		g_MC_Loc[0].ClericMsgFix = "clerics will only bless once a holy time! Next possible bless in "
		g_MC_Loc[0].AntiSellBug = "Building in progress of Destruction already"
		g_MC_Loc[0].NotBuildRule = "No Village Center stealing! Ressources are wasted!"
		g_MC_Loc[0].NotBuildRuleWarning = "Not allowed Village Center placement! It will be destroyed in 5 Seconds!"
		g_MC_Loc[0].WinMsg = "@color:0,255,0 You have won the game!"
		g_MC_Loc[0].LooseMsg = "Your settlement has been @color:255,0,0 wiped out @color:255,255,255 ."
		g_MC_Loc[0].LooseMsgWin = "@color:0,255,0 Your team swung the result! Your team has won!"
		g_MC_Loc[0].LooseMsgTotal = "@color:255,0,0 You have lost the game!"
		g_MC_Loc[0].FastGameSelection = "Start as Fast Game (multiple Ressources)"
		g_MC_Loc[0].HQInv = "Players "
		g_MC_Loc[0].HQInv_Invul = " Headquarter is indestructable now"
		g_MC_Loc[0].HQInv_Vul = " Headquarter is attackable now"
		g_MC_Loc[0].Random = "Random Rule Generator"
		
		--CtF Messages
		
		g_MC_Loc[0].FlagNowHolding = "now is holding the flag!"
		g_MC_Loc[0].FlagCaptured = "captured the flag!"
		g_MC_Loc[0].FlagScore = "Score"
		g_MC_Loc[0].FlagHolderDead = "The flag holding hero died!"
		g_MC_Loc[0].FlagReset = "Flag holding limit reached! Flag reset!"
		
		--Loc_RulesetStep = {}
		g_MC_Loc[0].Rule = {}
		for i = 1, 9 do
		g_MC_Loc[0].Rule[i] = {}
		end
		
		g_MC_Loc[0].Rule["WS"] = {}
		g_MC_Loc[0].Rule["WS"].Name = "Peacetime"

		g_MC_Loc[0].Rule["MaxHeroes"] = {}
		g_MC_Loc[0].Rule["MaxHeroes"].Name = "Max. Heroes"

		g_MC_Loc[0].Rule["TradeLimit"] = {}
		g_MC_Loc[0].Rule["TradeLimit"].Name = "Limit Single Trade"

		g_MC_Loc[0].Rule["Playermode"] = {}
		g_MC_Loc[0].Rule["Playermode"].Name = "Playermode" 

		g_MC_Loc[0].Rule["Weathermin"] = {}
		g_MC_Loc[0].Rule["Weathermin"].Name = "Weaterchange block / min" 
		
		g_MC_Loc[0].Rule["Maxtowers"] = {}
		g_MC_Loc[0].Rule["Maxtowers"].Name = "Maxtowers" 
		g_MC_Loc[0].Rule["Maxtowers"].Msg = "Max Towers reached"
		g_MC_Loc[0].Rule["Maxtowers"].Cheat = "Max Tower Cheat detected! Tower destroyed without ressource payback"

		g_MC_Loc[0].Rule["FlagPoints"] = {}
		g_MC_Loc[0].Rule["FlagPoints"].Name = "CtF Points to get" 

		g_MC_Loc[0].Rule["FlagMaxHoldtime"] = {}
		g_MC_Loc[0].Rule["FlagMaxHoldtime"].Name = "Maximal Flagholding / seconds" 

		g_MC_Loc[0].Rule["FlagRange"] = {}
		g_MC_Loc[0].Rule["FlagRange"].Name = "Range at Flag" 
		
		g_MC_Loc[0].Rule["FlagActive"] = {}
		g_MC_Loc[0].Rule["FlagActive"].Name = "Capture the Flag"
		g_MC_Loc[0].Rule["FlagActive"][1] = "Activ"
		g_MC_Loc[0].Rule["FlagActive"][2] = "Indestructable-HQ"
		g_MC_Loc[0].Rule["FlagActive"].FlagHolder = "Flagholder"
		g_MC_Loc[0].Rule["FlagActive"].Timer	= "Limit"
		
		g_MC_Loc[0].Rule["Units1"] = {}
		g_MC_Loc[0].Rule["Units1"].Name = "Units"
		g_MC_Loc[0].Rule["Units1"][1] = "Heavy Cavalry";
		g_MC_Loc[0].Rule["Units1"][2] = "Light Cavalry";
		g_MC_Loc[0].Rule["Units1"][3] = "Heavy Canons";
		g_MC_Loc[0].Rule["Units1"][4] = "Light Canons";
		g_MC_Loc[0].Rule["Units1"][5] = "Marksman";
		g_MC_Loc[0].Rule["Units1"][6] = "Thief";

		g_MC_Loc[0].Rule["MapSpecial"] = {}
		g_MC_Loc[0].Rule["MapSpecial"].Name = "Map"
		
		g_MC_Loc[0].Rule["Buildings1"] = {}
		g_MC_Loc[0].Rule["Buildings1"].Name = "Buildings"   
		g_MC_Loc[0].Rule["Buildings1"][1] = "Canon Tower";
		g_MC_Loc[0].Rule["Buildings1"][2] = "Ballista Tower";
		g_MC_Loc[0].Rule["Buildings1"][3] = "Market Place";
		g_MC_Loc[0].Rule["Buildings1"][4] = "Bridge";
		g_MC_Loc[0].Rule["Buildings1"][5] = "-";
		g_MC_Loc[0].Rule["Buildings1"][6] = "-";

		g_MC_Loc[0].Rule["Weather"] = {}		
		g_MC_Loc[0].Rule["Weather"].Name = "Weather"   
		g_MC_Loc[0].Rule["Weather"][1] = "Winter";
		g_MC_Loc[0].Rule["Weather"][2] = "Rain";
		g_MC_Loc[0].Rule["Weather"][3] = "Summer";
		
		g_MC_Loc[0].Rule["Special1"] = {}   
		g_MC_Loc[0].Rule["Special1"].Name = "Special:"     
		g_MC_Loc[0].Rule["Special1"][1] = "Anti-Destroy-Bug";
		g_MC_Loc[0].Rule["Special1"][2] = "Bless Limit";
		g_MC_Loc[0].Rule["Special1"][3] = "VC assigned (team)";	   
		g_MC_Loc[0].Rule["Special1"][4] = "VC assigned (players)";
		g_MC_Loc[0].Rule["Special1"][5] = "Anti-HQRush";
		g_MC_Loc[0].Rule["Special1"][6] = "Pauseblock";

		g_MC_Loc[0].Rule["Special2"] = {}   
		g_MC_Loc[0].Rule["Special2"].Name = "Special:"     
		g_MC_Loc[0].Rule["Special2"][1] = "Unsellable Starttowers"
		g_MC_Loc[0].Rule["Special2"][2] = "Indestructable Starttowers"
		g_MC_Loc[0].Rule["Special2"][3] = "No Starttowers";
		g_MC_Loc[0].Rule["Special2"][4] = "Maxtowers";
		g_MC_Loc[0].Rule["Special2"][5] = "BuildWalls";
		g_MC_Loc[0].Rule["Special2"][6] = "SpeedStart";
		
		g_MC_Loc[0].Rule["Heroes"] = {}
		g_MC_Loc[0].Rule["Heroes"].Name = "Allow/Forbit Hero" 
		g_MC_Loc[0].Rule["Heroes"][1] = "Dario"
		g_MC_Loc[0].Rule["Heroes"][2] = "Ari"
		g_MC_Loc[0].Rule["Heroes"][3] = "Erec"
		g_MC_Loc[0].Rule["Heroes"][4] = "Salim"
		g_MC_Loc[0].Rule["Heroes"][5] = "Pilgrim"
		g_MC_Loc[0].Rule["Heroes"][6] = "Helias"
		g_MC_Loc[0].Rule["Heroes"][7] = "Mary"
		g_MC_Loc[0].Rule["Heroes"][8] = "Kerberos"
		g_MC_Loc[0].Rule["Heroes"][9] = "Varg"
		g_MC_Loc[0].Rule["Heroes"][10] = "Drake"
		g_MC_Loc[0].Rule["Heroes"][11] = "Yuki"	   	   
		g_MC_Loc[0].Rule["Heroes"][12] = "Kala"


		
		-- GERMAN
		g_MC_Loc[1] = {}
		g_MC_Loc[1].Peacetime = "Friedenszeit"
		g_MC_Loc[1].Wartimemsg = "Jetzt wird gekaempft!"
		g_MC_Loc[1].Minutes = "Minuten"
		g_MC_Loc[1].Selected = "Ausgewaehlt!"
		g_MC_Loc[1].GoOn = "Weiter"
		g_MC_Loc[1].Back = "Zurueck"
		g_MC_Loc[1].Allowed = "erlaubt"
		g_MC_Loc[1].Forbitten = "verboten"
		g_MC_Loc[1].ForbittenUnits = "Nach Regeln verboten"
		g_MC_Loc[1].Yes = "Ja"
		g_MC_Loc[1].No = "Nein"
		g_MC_Loc[1].StartGame = "Spiel starten"
		g_MC_Loc[1].GameStarts = "Spiel beginnt"
		g_MC_Loc[1].AsFastGame = "als Fastgame"
		g_MC_Loc[1].In = "in"
		g_MC_Loc[1].Seconds = "Sekunden"
		g_MC_Loc[1].ChangeStatus = "Aendere Status"
		g_MC_Loc[1].Weather = "Wetter"
		g_MC_Loc[1].Special = "Spezialregeln"
		g_MC_Loc[1].Buildings = "Gebaeude"
		g_MC_Loc[1].Units = "Einheiten"
		g_MC_Loc[1].Rules = "Regeln"
		g_MC_Loc[1].Activate = "Aktivieren"
		g_MC_Loc[1].Deactivate = "Deaktivieren"
		g_MC_Loc[1].Deactivated = "Deaktiviert"
		g_MC_Loc[1].Showrules = "Regelanzeige"
		g_MC_Loc[1].ClericMsg = "Prieser stehen ueber dem Gesetz und werden keine Ueberstunden schieben"
		g_MC_Loc[1].ClericMsgFix = "Eure Priester werden nur einmal alle Zeiten die heiligen Glocken laeuten! Naechste Moeglichkeit in "
		g_MC_Loc[1].AntiSellBug = "Gebaeude wird bereits zerstoert"
		g_MC_Loc[1].NotBuildRule = "Kein DZ-Klau! Ressourcen verschwendet!"
		g_MC_Loc[1].NotBuildRuleWarning = "Unerlaubte DZ Platzierung! Es wird in 5 Sekunden zerstoert!"
		g_MC_Loc[1].WinMsg = "@color:0,255,0 Du hast das Spiel gewonnen!"
		g_MC_Loc[1].LooseMsg = "Deine Siedlung wurde @color:255,0,0 ausgeloescht @color:255,255,255 ."
		g_MC_Loc[1].LooseMsgWin = "@color:0,255,0 Dein Team hat es herumgerissen! Dein Team hat gewonnen!"
		g_MC_Loc[1].LooseMsgTotal = "@color:255,0,0 Du hast das Spiel endgueltig verloren!"
		g_MC_Loc[1].FastGameSelection = "Starten als Fast Game (vielfache Ressourcen)"
		g_MC_Loc[1].HQInv = "Das Hauptquartier von Spieler "
		g_MC_Loc[1].HQInv_Invul = " ist nun unverwundbar"
		g_MC_Loc[1].HQInv_Vul = " ist nun angreifbar"
		g_MC_Loc[1].Random = "Zufallsregelngenerator"

		--CtF Messages
		
		g_MC_Loc[1].FlagNowHolding = "hat jetzt die Flagge!"
		g_MC_Loc[1].FlagCaptured = "hat die Flagge erobert!"
		g_MC_Loc[1].FlagScore = "Punkte"
		g_MC_Loc[1].FlagHolderDead = "der Flaggenhalter ist gestorben!"
		g_MC_Loc[1].FlagReset = "Flaggenhaltelimit erreicht! Flagge wird zurueckgesetzt!"
		

		--Loc_RulesetStep = {}

		g_MC_Loc[1].Rule = {}
		for i = 1, 9 do
		g_MC_Loc[1].Rule[i] = {}
		end
		g_MC_Loc[1].Rule["WS"] = {}
		g_MC_Loc[1].Rule["WS"].Name = "Friedenszeit"

		g_MC_Loc[1].Rule["MaxHeroes"] = {}
		g_MC_Loc[1].Rule["MaxHeroes"].Name = "Max. Helden"

		g_MC_Loc[1].Rule["TradeLimit"] = {}
		g_MC_Loc[1].Rule["TradeLimit"].Name = "Limit Einzelhandel"

		g_MC_Loc[1].Rule["Playermode"] = {}
		g_MC_Loc[1].Rule["Playermode"].Name = "Playermode" 

		g_MC_Loc[1].Rule["Weathermin"] = {}
		g_MC_Loc[1].Rule["Weathermin"].Name = "Wetterwechselsperre / min" 
		
		g_MC_Loc[1].Rule["Maxtowers"] = {}
		g_MC_Loc[1].Rule["Maxtowers"].Name = "Maxtowers" 
		g_MC_Loc[1].Rule["Maxtowers"].Msg = "Max Towers erreicht"
		g_MC_Loc[1].Rule["Maxtowers"].Cheat = "Max Tower Cheat erkannt! Turm ohne Rckzahlung zerstrt"
		
		g_MC_Loc[1].Rule["FlagPoints"] = {}
		g_MC_Loc[1].Rule["FlagPoints"].Name = "CtF Punkte bis Sieg" 

		g_MC_Loc[1].Rule["FlagMaxHoldtime"] = {}
		g_MC_Loc[1].Rule["FlagMaxHoldtime"].Name = "Maximale Flaggenhaltelimit / Sekunden" 

		g_MC_Loc[1].Rule["FlagRange"] = {}
		g_MC_Loc[1].Rule["FlagRange"].Name = "Reichweite der Flagge" 

		g_MC_Loc[1].Rule["MapSpecial"] = {}
		g_MC_Loc[1].Rule["MapSpecial"].Name = "Map"
		
		g_MC_Loc[1].Rule["FlagActive"] = {}
		g_MC_Loc[1].Rule["FlagActive"].Name = "Capture the Flag"
		g_MC_Loc[1].Rule["FlagActive"][1] = "Aktiv"
		g_MC_Loc[1].Rule["FlagActive"][2] = "Unzerstoerbare-HQ"
		g_MC_Loc[1].Rule["FlagActive"].FlagHolder = "Flaggenhalter"
		g_MC_Loc[1].Rule["FlagActive"].Timer	= "Limit"
		
		g_MC_Loc[1].Rule["Units1"] = {}
		g_MC_Loc[1].Rule["Units1"].Name = "Einheiten"
		g_MC_Loc[1].Rule["Units1"][1] = "Schwere Kavallerie";
		g_MC_Loc[1].Rule["Units1"][2] = "Leichte Kavallerie";
		g_MC_Loc[1].Rule["Units1"][3] = "Schwere Kanonen";
		g_MC_Loc[1].Rule["Units1"][4] = "Leichte Kanonen";
		g_MC_Loc[1].Rule["Units1"][5] = "Scharfschuetzen";
		g_MC_Loc[1].Rule["Units1"][6] = "Diebe";

		g_MC_Loc[1].Rule["Buildings1"] = {}
		g_MC_Loc[1].Rule["Buildings1"].Name = "Gebaeude"   
		g_MC_Loc[1].Rule["Buildings1"][1] = "Kanonentuerme";
		g_MC_Loc[1].Rule["Buildings1"][2] = "Ballistatuerme";
		g_MC_Loc[1].Rule["Buildings1"][3] = "Marktplaetze";
		g_MC_Loc[1].Rule["Buildings1"][4] = "Bruecke";
		g_MC_Loc[1].Rule["Buildings1"][5] = "-";
		g_MC_Loc[1].Rule["Buildings1"][6] = "-";

		g_MC_Loc[1].Rule["Weather"] = {}
		g_MC_Loc[1].Rule["Weather"].Name = "Wetter"   
		g_MC_Loc[1].Rule["Weather"][1] = "Winter";
		g_MC_Loc[1].Rule["Weather"][2] = "Regen";
		g_MC_Loc[1].Rule["Weather"][3] = "Sommer";

		g_MC_Loc[1].Rule["Special1"] = {}
		g_MC_Loc[1].Rule["Special1"].Name = "Spezial:"     
		g_MC_Loc[1].Rule["Special1"][1] = "Anti-Abreissbug";
		g_MC_Loc[1].Rule["Special1"][2] = "Segnenlimit";
		g_MC_Loc[1].Rule["Special1"][3] = "DZ zugeordnet (team)";
		g_MC_Loc[1].Rule["Special1"][4] = "DZ zugeordnet (spieler)";
		g_MC_Loc[1].Rule["Special1"][5] = "Anti-Burgrush";
		g_MC_Loc[1].Rule["Special1"][6] = "Pauseblock";

		g_MC_Loc[1].Rule["Special2"] = {}   
		g_MC_Loc[1].Rule["Special2"].Name = "Special:"     
		g_MC_Loc[1].Rule["Special2"][1] = "Starttuerme unverkaufbar"
		g_MC_Loc[1].Rule["Special2"][2] = "Starttuerme unzerstoerbar";
		g_MC_Loc[1].Rule["Special2"][3] = "Keine Starttuerme";
		g_MC_Loc[1].Rule["Special2"][4] = "Maxtowers";
		g_MC_Loc[1].Rule["Special2"][5] = "Mauerbau";
		g_MC_Loc[1].Rule["Special2"][6] = "SpeedStart";
		
		g_MC_Loc[1].Rule["Heroes"] = {}
		g_MC_Loc[1].Rule["Heroes"].Name = "Erlaubte Helden" 
		g_MC_Loc[1].Rule["Heroes"][1] = "Dario"
		g_MC_Loc[1].Rule["Heroes"][2] = "Ari"
		g_MC_Loc[1].Rule["Heroes"][3] = "Erec"
		g_MC_Loc[1].Rule["Heroes"][4] = "Salim"
		g_MC_Loc[1].Rule["Heroes"][5] = "Pilgrim"
		g_MC_Loc[1].Rule["Heroes"][6] = "Helias"
		g_MC_Loc[1].Rule["Heroes"][7] = "Mary"
		g_MC_Loc[1].Rule["Heroes"][8] = "Kerberos"
		g_MC_Loc[1].Rule["Heroes"][9] = "Varg"
		g_MC_Loc[1].Rule["Heroes"][10] = "Drake"
		g_MC_Loc[1].Rule["Heroes"][11] = "Yuki"	   	   
		g_MC_Loc[1].Rule["Heroes"][12] = "Kala"
		-- polnisch
		g_MC_Loc[2] = {}
		g_MC_Loc[2].Peacetime = "Czas Pokoju"
		g_MC_Loc[2].Wartimemsg = "Walczmy!"
		g_MC_Loc[2].Minutes ="Minuty"
		g_MC_Loc[2].Selected = "Wybrany"
		g_MC_Loc[2].GoOn = "Dalej"
		g_MC_Loc[2].Back = "Wroc"
		g_MC_Loc[2].Allowed = "Dozwolone"
		g_MC_Loc[2].Forbitten = "Zabronione"
		g_MC_Loc[2].ForbittenUnits = "Jednostki Zabronione"
		g_MC_Loc[2].Yes = "Tak"
		g_MC_Loc[2].No = "Nie"
		g_MC_Loc[2].StartGame = "Poczatek Gry"
		g_MC_Loc[2].GameStarts = "Gra rozpoczela sie"
		g_MC_Loc[2].AsFastGame = "Jako szybka gra"
		g_MC_Loc[2].In = "w"
		g_MC_Loc[2].Seconds = "Sekundy"
		g_MC_Loc[2].ChangeStatus = "Zmiana Statusu"
		g_MC_Loc[2].Weather = "Pogoda"
		g_MC_Loc[2].Special = "Dodatkowe Zasady"
		g_MC_Loc[2].Buildings = "Budynki"
		g_MC_Loc[2].Units = "Jednostki"
		g_MC_Loc[2].Rules = "Zasady"
		g_MC_Loc[2].Activate = "Aktywowane"
		g_MC_Loc[2].Deactivate = "Deaktywowac"
		g_MC_Loc[2].Deactivated = "Nieaktywne"
		g_MC_Loc[2].Showrules = "Pokaz Zasady"
		g_MC_Loc[2].ClericMsg = "Duchownych nie obowiazuje prawo-nie odpracowuja godzin nadliczbowych"
		g_MC_Loc[2].ClericMsgFix = "(sry no translation yet) clerics will only bless special people once a holy time! Next possible bless in "
		g_MC_Loc[2].AntiSellBug = "Budynek jest w czasie burzenia"
		g_MC_Loc[2].NotBuildRule = "Nie kradnij Osrodka Wiejskiego!Surowce sa wyczerpane!"
		g_MC_Loc[2].NotBuildRuleWarning = "Not allowed Village Center placement! It will be destroyed in 5 Seconds!"
		g_MC_Loc[2].WinMsg = "@color:0,255,0 Wygrales Gre"
		g_MC_Loc[2].LooseMsg = "Twoja osada zostala @color:255,0,0 zniszczona @color:255,255,255 ."
		g_MC_Loc[2].LooseMsgWin = "@color:0,255,0 Twoj zespol odwrocil losy rozgrywki!Twoja druzyna wygrala!"
		g_MC_Loc[2].LooseMsgTotal = "Przegrales Gre!"
		g_MC_Loc[2].FastGameSelection = "Rozpocznij Szybka Gre (wiecej surowcow)"
		g_MC_Loc[2].HQInv = "gracz "
		g_MC_Loc[2].HQInv_Invul = " - niezniszczalny zamek obecnie"
		g_MC_Loc[2].HQInv_Vul = " - zniszczalny zamek obecnie"
		g_MC_Loc[2].Random = "(sry no translation yet) Random Rule Generator"

		g_MC_Loc[2].FlagNowHolding = "now is holding the flag!"
		g_MC_Loc[2].FlagCaptured = "captured the flag!"
		g_MC_Loc[2].FlagScore = "Score"
		g_MC_Loc[2].FlagHolderDead = "The flag holding hero died!"
		g_MC_Loc[2].FlagReset = "Flag holding limit reached! Flag reset!"
		
		--Loc_RulesetStep = {}
		g_MC_Loc[2].Rule = {}
		for i = 1, 9 do
			g_MC_Loc[2].Rule[i] = {}
		end
		g_MC_Loc[2].Rule["WS"] = {}
		g_MC_Loc[2].Rule["WS"].Name = "Czas Pokoju"

		g_MC_Loc[2].Rule["MaxHeroes"] = {}
		g_MC_Loc[2].Rule["MaxHeroes"].Name = "Maksymalna ilosc bohaterow"

		g_MC_Loc[2].Rule["TradeLimit"] = {}
		g_MC_Loc[2].Rule["TradeLimit"].Name = "Limit pojedynczego handlu"

		g_MC_Loc[2].Rule["Playermode"] = {}
		g_MC_Loc[2].Rule["Playermode"].Name = "Playermode" 

		g_MC_Loc[2].Rule["Weathermin"] = {}
		g_MC_Loc[2].Rule["Weathermin"].Name = "Weaterchange block / min" 
		
		g_MC_Loc[2].Rule["Maxtowers"] = {}
		g_MC_Loc[2].Rule["Maxtowers"].Name = "Maxtowers" 
		g_MC_Loc[2].Rule["Maxtowers"].Msg = "Max Towers erreicht"
		g_MC_Loc[2].Rule["Maxtowers"].Cheat = "Max Tower Cheat detected! Tower destroyed without ressource payback"
		
		g_MC_Loc[2].Rule["FlagPoints"] = {}
		g_MC_Loc[2].Rule["FlagPoints"].Name = "CtF Points to get" 

		g_MC_Loc[2].Rule["FlagMaxHoldtime"] = {}
		g_MC_Loc[2].Rule["FlagMaxHoldtime"].Name = "Maximal Flagholding / seconds" 

		g_MC_Loc[2].Rule["FlagRange"] = {}
		g_MC_Loc[2].Rule["FlagRange"].Name = "Range at Flag" 

		g_MC_Loc[2].Rule["MapSpecial"] = {}
		g_MC_Loc[2].Rule["MapSpecial"].Name = "Map"
		
		g_MC_Loc[2].Rule["FlagActive"] = {}
		g_MC_Loc[2].Rule["FlagActive"].Name = "Capture the Flag"
		g_MC_Loc[2].Rule["FlagActive"][1] = "Activ"
		g_MC_Loc[2].Rule["FlagActive"][2] = "Indestructable-HQ"
		g_MC_Loc[2].Rule["FlagActive"].FlagHolder = "Flagholder"
		g_MC_Loc[2].Rule["FlagActive"].Timer	= "Limit"
		
		g_MC_Loc[2].Rule["Units1"] = {}
		g_MC_Loc[2].Rule["Units1"].Name = "Jednostki"
		g_MC_Loc[2].Rule["Units1"][1] = "Ciezka Kawaleria";
		g_MC_Loc[2].Rule["Units1"][2] = "Lekka Kawaleria";
		g_MC_Loc[2].Rule["Units1"][3] = "Ciezkie Dziala";
		g_MC_Loc[2].Rule["Units1"][4] = "Lekkie Dziala";
		g_MC_Loc[2].Rule["Units1"][5] = "Strzelec Wyborowy";
		g_MC_Loc[2].Rule["Units1"][6] = "Zlodziej";

		g_MC_Loc[2].Rule["Buildings1"] = {}
		g_MC_Loc[2].Rule["Buildings1"].Name = "Budynki"
		g_MC_Loc[2].Rule["Buildings1"][1] = "Wieza z dzialem ";
		g_MC_Loc[2].Rule["Buildings1"][2] = "Wieza z balista";
		g_MC_Loc[2].Rule["Buildings1"][3] = "Targowisko";
		g_MC_Loc[2].Rule["Buildings1"][4] = "(nt)Bridge";
		g_MC_Loc[2].Rule["Buildings1"][5] = "-";
		g_MC_Loc[2].Rule["Buildings1"][6] = "-";

		g_MC_Loc[2].Rule["Weather"] = {}
		g_MC_Loc[2].Rule["Weather"].Name = "Pogoda"
		g_MC_Loc[2].Rule["Weather"][1] = "Zima";
		g_MC_Loc[2].Rule["Weather"][2] = "Deszcz";
		g_MC_Loc[2].Rule["Weather"][3] = "Lato";

		g_MC_Loc[2].Rule["Special1"] = {}
		g_MC_Loc[2].Rule["Special1"].Name = "Dodatkowo:"
		g_MC_Loc[2].Rule["Special1"][1] = "Bez Bug-a Surowcowego";
		g_MC_Loc[2].Rule["Special1"][2] = "Kler bez nadgodzin";
		g_MC_Loc[2].Rule["Special1"][3] = "Przydzielono Osrodki Wiejskie (zespol)";
		g_MC_Loc[2].Rule["Special1"][4] = "Przydzielono Osrodki Wiejskie (gracz)";
		g_MC_Loc[2].Rule["Special1"][5] = "Anti-HQ-Rush";
		g_MC_Loc[2].Rule["Special1"][6] = "Pauseblock";

		g_MC_Loc[2].Rule["Special2"] = {}   
		g_MC_Loc[2].Rule["Special2"].Name = "Special:"     
		g_MC_Loc[2].Rule["Special2"][1] = "Unsellable Starttowers"
		g_MC_Loc[2].Rule["Special2"][2] = "Indestructable Starttowers";
		g_MC_Loc[2].Rule["Special2"][3] = "No Starttowers";
		g_MC_Loc[2].Rule["Special2"][4] = "Maxtowers";
		g_MC_Loc[2].Rule["Special2"][5] = "BuildWalls";
		g_MC_Loc[2].Rule["Special2"][6] = "SpeedStart";
		
		g_MC_Loc[2].Rule["Heroes"] = {}
		g_MC_Loc[2].Rule["Heroes"].Name = "Dozwoleni/Zabronieni bohaterowie"
		g_MC_Loc[2].Rule["Heroes"][1] = "Dario"
		g_MC_Loc[2].Rule["Heroes"][2] = "Ari"
		g_MC_Loc[2].Rule["Heroes"][3] = "Erec"
		g_MC_Loc[2].Rule["Heroes"][4] = "Salim"
		g_MC_Loc[2].Rule["Heroes"][5] = "Pielgrzym"
		g_MC_Loc[2].Rule["Heroes"][6] = "Heliasz"
		g_MC_Loc[2].Rule["Heroes"][7] = "Mary"
		g_MC_Loc[2].Rule["Heroes"][8] = "Cerber"
		g_MC_Loc[2].Rule["Heroes"][9] = "Varg"
		g_MC_Loc[2].Rule["Heroes"][10] = "Drake"
		g_MC_Loc[2].Rule["Heroes"][11] = "Yuki"
		g_MC_Loc[2].Rule["Heroes"][12] = "Kala" 	   
		
	end
	
	VerifyRulesets = function()
		
		if mpc_Rules.FastGame[1] then
			local mal = mpc_Rules.FastGame.Multiplicator
			g_MC_StR = { Gold = g_MC_StR.Gold * mal, Clay = g_MC_StR.Clay * mal, Wood = g_MC_StR.Wood * mal,
						Stone = g_MC_StR.Stone * mal, Iron = g_MC_StR.Iron * mal, Sulfur = g_MC_StR.Sulfur * mal }
		end
		for i = 1,8 do
			if not mpc_Rules["Units1"].Act[1] then ForbidTechnology(Technologies.MU_LeaderHeavyCavalry, i); end
			if not mpc_Rules["Units1"].Act[2] then ForbidTechnology(Technologies.MU_LeaderLightCavalry, i); end
			if not mpc_Rules["Units1"].Act[3] then ForbidTechnology(Technologies.MU_Cannon2, i); ForbidTechnology(Technologies.MU_Cannon4, i); end
			if not mpc_Rules["Units1"].Act[4] then ForbidTechnology(Technologies.MU_Cannon1, i); ForbidTechnology(Technologies.MU_Cannon3, i); end
			if not mpc_Rules["Units1"].Act[5] then ForbidTechnology(Technologies.B_GunsmithWorkshop, i); end
			if not mpc_Rules["Units1"].Act[6] then ForbidTechnology(Technologies.MU_Thief, i); end
			if not mpc_Rules["Buildings1"].Act[2] then ForbidTechnology(Technologies.UP1_Tower, i); end
			if not mpc_Rules["Buildings1"].Act[1] then ForbidTechnology(Technologies.UP2_Tower, i); end
			if not mpc_Rules["Buildings1"].Act[3] then ForbidTechnology(Technologies.UP1_Market, i); end
			if not mpc_Rules["Buildings1"].Act[4] then ForbidTechnology(Technologies.B_Bridge, i); end
			if not mpc_Rules["Weather"].Act[1] then ForbidTechnology(Technologies.T_MakeSnow, i); end
			if not mpc_Rules["Weather"].Act[2] then ForbidTechnology(Technologies.T_MakeRain, i); end
			if not mpc_Rules["Weather"].Act[3] then ForbidTechnology(Technologies.T_MakeSummer, i); end
		end		
				
		if mpc_Rules["Special2"].Act[1] then
			table.insert(GUI.SellBuilding_BeforeOrig,
				function()
					for v = 1,6 do
						for u = 1, table.getn( mpc_towers[gv_guipId][ v ] ) do
							if GUI.GetSelectedEntity() == mpc_towers[gv_guipId][ v ][u] then
								Message(g_MC_Loc[0].Rule["Special2"][1])
								return false
							end
						end
					end	
				end
			)
		end		
		if mpc_Rules["Special1"].Act[1] then
			gvAlreadyDestructed = {}
			for i=1,8 do
				gvAlreadyDestructed[i] = 0
			end				
			table.insert(GUI.SellBuilding_BeforeOrig,
				function()
					if gvAlreadyDestructed[gv_guipId] == GUI.GetSelectedEntity() then
						Message(g_MC_Loc[lang].AntiSellBug)
						return false
					end
				end
			)
			table.insert(GUI.SellBuilding_AfterOrig,
				function()
					gvAlreadyDestructed[gv_guipId] = GUI.GetSelectedEntity()
				end
			)
		end

		StartSimpleJob("GameStart")
		StartSimpleJob("mpc_HideLooseMsgForNotPlayers")
		mpc_SetupPlayerView()
	end
	
	ErfasseStartTuerme = function()
		mpc_towers = {}
		for _pId = 1,8 do
			mpc_towers[_pId] = {} 
			for i = 1, table.getn(gv_Entities_Tuerme) do
				mpc_towers[_pId][i] = {}
				for u = 1, table.getn( Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ] ) do
					if mpc_Rules["Special2"].Act[3] then
						Logic.ResumeEntity(Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ][1])
						DestroyEntity(Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ][1])
					else
						mpc_towers[_pId][i][u] = Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ][u]
						if mpc_Rules["Special2"].Act[2] then
							MakeInvulnerable(mpc_towers[_pId][i][u])
						end	
					end
					
				end
			end
		end		
	end
	
	GameStart = function()
		GameStartStarted = false
		if mpc_GameStartDelay == 0 then
			GameStartStarted = true
			if mpc_Rules["FlagActive"].Act[1] then
				CaptureTheFlagOnChoosen()
			end
			if mpc_Rules["Special2"].Act[5] then
				SetupWalls()
			end	
			Logic.ResumeAllEntities()
			-- Bless Timer Limit neu setzen nach eigener Konfiguration
			for i = 1,8 do
				mpc_Rules.BlessTimer[i] = {}
				for u = 1,5 do
					mpc_Rules.BlessTimer[i][u] = -1 * mpc_Rules["Special1"].TimeBetweenBlessings
				end
			end
			
			-- Starttrme erfassen fr Unverkaufbar-Regel und ggf. Unzerstrbar machen.
			ErfasseStartTuerme()

			-- Kaufbare Helden setzen wenn nach Einstellung der Spieler auch spielt
			for i = 1,8 do
				if mpc_MultiplayerPlaying[i] then
					Logic.SetNumberOfBuyableHerosForPlayer(i,mpc_Rules.MaxHeroes[mpc_Rules.MaxHeroes.Cur])
				end
			end
		
			-- Verbotene Helden unkaufbar machen
			for i = 1,12 do
				if mpc_Rules["Heroes"].Act[i] then
					GUIAction_ToggleMenu("BuyHeroWindowBuyHero"..i, 1)
				end
			end
			
			
			StatisticLogging()
			if mpc_Rules.statisticLog then
				StatisticLogStartLogging()
			end
			
			-- Los gehts!
			ReBuildAllPlayerVillageCenters()
			Message("@color:0,255,0 "..g_MC_Loc[lang].GameStarts.."!")
			HideMovieFenster(true)
			SetPeacetime( mpc_Rules["WS"][mpc_Rules["WS"].Cur]*60 )
			Mission_InitLocalResources()
			if mpc_Rules["Special2"].Act[6] then
				for _pId = 1,8 do
					if mpc_MultiplayerPlaying[_pId] then
						Tools.GiveResouces(_pId, 20000 , 10000, 10000, 10000, 7500, 7500)
					end
				end
			end
			gv_MC_GameStateJob = StartSimpleJob("PlayerGameStateCheck")
			Sound.PlayGUISound( Sounds.fanfare, 127 )
			-- Mapspezieller Callback bei Gamestart
			SpecialMapGameStartCallback()
			return true
		end
		mpc_GameStartDelay = mpc_GameStartDelay - 1

	end

	ReBuildAllPlayerVillageCenters = function()   	
		for _pId = 1, 8 do
			if mpc_MultiplayerPlaying[_pId] then
				for u = 1,table.getn(mpc_villageCenters[_pId][ mpc_Rules["DorfzentrumLvL"] ] ) do
					Logic.CreateEntity( gv_Entities_Dorfzentren[mpc_Rules["DorfzentrumLvL"]], mpc_villageCenters[_pId][mpc_Rules["DorfzentrumLvL"]][u].pos.X, mpc_villageCenters[_pId][mpc_Rules["DorfzentrumLvL"]][u].pos.Y, 0, _pId )
				end
			end
		end
	end

	ClearAllPlayerVillageCenters = function()
		mpc_villageCenters = {}
		for _pId = 1,8 do
			mpc_villageCenters[_pId] = {} 
			for v = 1,table.getn(gv_Entities_Dorfzentren) do
				mpc_villageCenters[_pId][v] = {}
				for u = 1, table.getn( Track_Entity_Table[_pId][ gv_Entities_Dorfzentren[v] ] ) do
					mpc_villageCenters[_pId][v][u] = {}
					mpc_villageCenters[_pId][v][u].pos = GetPosition ( Track_Entity_Table[_pId][ gv_Entities_Dorfzentren[v] ][1] )
					DestroyEntity ( Track_Entity_Table[_pId][ gv_Entities_Dorfzentren[v] ][1] )
				end
			end		
		end
	end

	PlayerGameStateCheck = function()
		--mpc_Rules.statisticLog
		for _pId = 1,8 do		
			if Logic.PlayerGetGameState( _pId ) == 3 and gv_MC_imdead[_pId] == nil then
				if _pId == gv_guipId then	
					if mpc_MultiplayerPlaying[_pId] then GUI.AddStaticNote(g_MC_Loc[lang].LooseMsg) end
					GUIAction_ToggleMenu(600,0)
					StatisticsLog.TributeId = AddTribute( CreateATribute(gv_guipId, "Spielstatistiken ausgeben (Achtung, du verlaesst dadurch das Spiel!)", { Gold = 0}, StatisticsStringOutPut ) )
				end
				if mpc_Rules.statisticLog then
					PlayerEndGame(_pId)
				end
				gv_MC_imdead[_pId] = 1
			end
			if Logic.PlayerGetGameState( _pId ) == 2 then
				if mpc_playerteams[_pId] == mpc_playerteams[gv_guipId] then
					if gv_MC_imdead[gv_guipId] == nil then
						StatisticsLog.TributeId = AddTribute( CreateATribute(gv_guipId, "Spielstatistiken ausgeben (Achtung, du verlaesst dadurch das Spiel!)", { Gold = 0}, StatisticsStringOutPut ) )
						if mpc_MultiplayerPlaying[_pId] then GUI.AddStaticNote(g_MC_Loc[lang].WinMsg) end
					else 
						if mpc_MultiplayerPlaying[_pId] then GUI.AddStaticNote(g_MC_Loc[lang].LooseMsgWin) end
					end
				else
					StatisticsLog.TributeId = AddTribute( CreateATribute(gv_guipId, "Spielstatistiken ausgeben (Achtung, du verlaesst dadurch das Spiel!)", { Gold = 0}, StatisticsStringOutPut ) )
					if mpc_MultiplayerPlaying[_pId] then GUI.AddStaticNote(g_MC_Loc[lang].LooseMsgTotal) end
				end
				for u = 1,8 do
					if gv_MC_imdead[u] == nil then
						PlayerEndGame(u)
					end
				end
				GUIAction_ToggleMenu(600,0)
				EndJob(StatisticLogJobId)
				EndJob(gv_MC_GameStateJob)
				break
			end
		end
	end
	
	Max_Tradevalue_Limiting = function()
		_limitcheck = {gvGUI.MarketMoneyToBuy, gvGUI.MarketClayToBuy, gvGUI.MarketWoodToBuy, gvGUI.MarketStoneToBuy, gvGUI.MarketIronToBuy, gvGUI.MarketSulfurToBuy}
		if (_limitcheck[1] > mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur]) then gvGUI.MarketMoneyToBuy = mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur] end
		if (_limitcheck[2] > mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur]) then gvGUI.MarketClayToBuy = mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur] end	
		if (_limitcheck[3] > mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur]) then gvGUI.MarketWoodToBuy= mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur] end	
		if (_limitcheck[4] > mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur]) then gvGUI.MarketStoneToBuy = mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur] end	
		if (_limitcheck[5] > mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur]) then gvGUI.MarketIronToBuy = mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur] end	
		if (_limitcheck[6] > mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur]) then gvGUI.MarketSulfurToBuy = mpc_Rules.TradeLimit[mpc_Rules.TradeLimit.Cur] end	
	end

	CheckVillageCenterNoReplaceMent = function (_vcId)		
		for _pId = 1,8 do
			local _vcId_pos = GetPosition(_vcId)
			for v = 1,3 do						
				for u = 1, table.getn( mpc_villageCenters[_pId][v] ) do					
					if _vcId_pos.X == mpc_villageCenters[_pId][v][u].pos.X and _vcId_pos.Y == mpc_villageCenters[_pId][v][u].pos.Y then
						if mpc_Rules["Special1"].Act[4] then
							if not ( GetPlayer( _vcId ) == _pId )then
								if gv_guipId == GetPlayer(_vcId) then
									Message(g_MC_Loc[lang].NotBuildRuleWarning)
								end
								mpc_VillageCenterTimer[_vcId] = 5
								StartSimpleJob(CheckVillageCenterTimer,_vcId)
							end	
						else
							if not ( mpc_playerteams[GetPlayer( _vcId )] == mpc_playerteams[_pId] )then
								if gv_guipId == GetPlayer(_vcId) then
									Message(g_MC_Loc[lang].NotBuildRuleWarning)
								end
								mpc_VillageCenterTimer[_vcId] = 5
								StartSimpleJob(CheckVillageCenterTimer,_vcId)
							end								
						end
					end
				end
			end
		end			
	end
	
	CheckVillageCenterTimer = function(_vcId)
		if mpc_VillageCenterTimer[_vcId] == 0 then
			if gv_guipId == GetPlayer(_vcId) then
				Message(g_MC_Loc[lang].NotBuildRule)
			end
			DestroyEntity ( _vcId )
			return true
		end
		mpc_VillageCenterTimer[_vcId] = mpc_VillageCenterTimer[_vcId] - 1
	end	
	
	NoRushRuleCheck = function(_pId)
		-- Nur wenn das HQ nicht bereits unverwundbar ist. Wenn entweder die NoRushRule aktiviert ist oder CTF wenn CTF mit unverwundbarem HQ aktiviert ist.
		local HQinv = mpc_Rules.HQInv[_pId]
		mpc_Rules.HQInv[_pId] = false
		if ( not( mpc_Rules.HQInv[_pId] ) and ( ( mpc_Rules["Special1"].Act[5] ) or ( mpc_Rules["FlagActive"].Act[1] and mpc_Rules["FlagActive"].Act[2] ) ) ) then
			for i = 1,3 do
				for w = 1, table.getn( Track_Entity_Table[_pId][ gv_Entities_Dorfzentren[i] ] ) do
					if not ( mpc_Rules.HQInv[_pId] ) then
						if Logic.IsConstructionComplete(Track_Entity_Table[_pId][ gv_Entities_Dorfzentren[i] ][w]) == 1 then
							mpc_Rules.HQInv[_pId] = true
						else
							StartSimpleJob(NoRushRuleIsConstructionCompleteJob,Track_Entity_Table[_pId][ gv_Entities_Dorfzentren[i] ][w],_pId)
						end
					end
				end
			end
		end
		if not(HQinv == mpc_Rules.HQInv[_pId]) then
			for u = 1, table.getn( gv_Entities_HQs ) do
				for v = 1, table.getn( Track_Entity_Table[_pId][gv_Entities_HQs[u]] ) do
					if (mpc_Rules.HQInv[_pId]) then 
						MakeInvulnerable( Track_Entity_Table[_pId][gv_Entities_HQs[u]][v] )
					else
						MakeVulnerable( Track_Entity_Table[_pId][gv_Entities_HQs[u]][v] )
					end	
				end
			end
			if not(mpc_Rules.HQInv[_pId]) then 
				Message(g_MC_Loc[lang].HQInv.._pId.." "..gvCol.rot..g_MC_Loc[lang].HQInv_Vul) 
			else
				Message(g_MC_Loc[lang].HQInv.._pId.." "..gvCol.gruen..g_MC_Loc[lang].HQInv_Invul)
			end			
		end
	end
	
	NoRushRuleIsConstructionCompleteJob = function(_dzID,_pId)
		if Logic.IsConstructionComplete(_dzID) == 1 then
			NoRushRuleCheck(GetPlayer(_dzID))
			return true
		elseif IsDead(_dzID) then
			return true
		end
		if mpc_Rules.HQInv[_pId] then
			return true
		end
	end
	
	mpc_SetupPlayerView = function()
		-- Wenn der Spieler nicht spielt bewirkt Ressourcen senden garnix
		if not (mpc_MultiplayerPlaying[gv_guipId]) then
			GUI.MPTrade_SendResource_Orig = GUI.MPTrade_SendResource()
			GUI.MPTrade_SendResource = function()
			end
		end
		MPGame_ApplicationCallback_ReceivedChatMessage_Orig = MPGame_ApplicationCallback_ReceivedChatMessage
			MPGame_ApplicationCallback_ReceivedChatMessage = function(_a,_b,_c)
			-- a. Form: "_Spielerfarbe _Spielername _FarbeWeiss + _Text", bei Whisper alles ROT!
			-- b: Wenn Team dann 1, Wenn All oder Lobby oder Whisper dann 0
			-- c: 1 bei Chat oder Team, -1 bei Whisper ODER Lobby!
			local _first = string.find (_a, " ")
			if _first == nil then
				return true
			end
			local _second = string.find (_a, " ", _first+1)
			local _playername = string.sub (_a, _first+1, _second-1 )
			local _viewMessage = true
			if mpc_MultiplayerPlaying[gv_guipId] then
				if not(AllowRead[gv_guipId]) then
					for i = 1,8 do					
							if (mpc_playernames[i] == _playername and not(mpc_MultiplayerPlaying[i])) then
								_viewMessage = false
								break
							end					
					end
				end
				local _ForbitReadAll = false
				for i = 1,8 do
					if mpc_MultiplayerPlaying[i] and not(AllowReadAll[i]) then
						_ForbitReadAll = true					
					end
				end
				if _ForbitReadAll then
					for i = 1,8 do					
						if (mpc_playernames[i] == _playername and not(mpc_MultiplayerPlaying[i])) then
							_viewMessage = false
							break
						end					
					end					
				end
			end
			if _viewMessage then
				MPGame_ApplicationCallback_ReceivedChatMessage_Orig(_a,_b,_c)
			end
		end
		
		mpc_TRIBRuleFunc.Read = {}
		for i = 1,8 do
			local _i = i
			mpc_TRIBRuleFunc.Read[_i] = function() mpc_TRIB_SelectRead(_i) end
		end
		AllowRead = {}
		for i = 1,8 do
				AllowRead[i] = true
		end
		mpc_TRIB_SelectRead = function (_pId)
			AllowRead[_pId] = not AllowRead[_pId]
			mpc_CreatePlayerReadTributes(_pId) 	
		end	
		mpc_CreatePlayerReadTributes = function(_pId)
			local _text = ""
			if AllowRead[_pId] then
				_text = gvCol.rot.." Dont view chatmessages of visitors!"
			else
				_text = gvCol.gruen.." View chatmessages of visitors!"
			end	
			return AddTribute( CreateATribute(_pId, _text, { Gold = 0}, mpc_TRIBRuleFunc.Read[_pId] ) )	
		end

		mpc_TRIBRuleFunc.ReadAll = {}
		for i = 1,8 do
			local _i = i
			mpc_TRIBRuleFunc.ReadAll[_i] = function() mpc_TRIB_SelectReadAll(_i) end
		end
		AllowReadAll = {}
		for i = 1,8 do
			AllowReadAll[i] = true
		end
		mpc_TRIB_SelectReadAll = function (_pId)
			AllowReadAll[_pId] = not AllowReadAll[_pId]			
			mpc_CreatePlayerReadAllTributes(_pId) 	
		end		
		mpc_CreatePlayerReadAllTributes = function(_pId)
			local _text = ""
			if AllowReadAll[_pId] then
				_text = gvCol.rot.." Forbit all Chatmessages to players of visitors!"
			else
				_text = gvCol.gruen.." Allow all Chatmessages to players of visitors!"
			end	
			return AddTribute( CreateATribute(_pId, _text, { Gold = 0}, mpc_TRIBRuleFunc.ReadAll[_pId] ) )	
		end
	

		mpc_TRIBRuleFunc.view = {}
		for i = 1,8 do
			local _i = i
			mpc_TRIBRuleFunc.view[_i] = function() mpc_TRIB_SelectView(_i) end
		end	
		AllowView = {}
		for i = 1,8 do
			if mpc_MultiplayerPlaying[i] then
				AllowView[i] = false
			else
				AllowView[i] = true
			end
		end
		for i = 1,8 do
			for u = 1,8 do
				if not((mpc_MultiplayerPlaying[i] and mpc_MultiplayerPlaying[u]) or (i==u)) then
					if mpc_playerteams[i] == mpc_playerteams[u] then
						if mpc_MultiplayerPlaying[i] then
							if AllowView[i] then
								Logic.SetShareExplorationWithPlayerFlag(i, u, 1);
								Logic.SetShareExplorationWithPlayerFlag(u, i, 1);
							else
								Logic.SetShareExplorationWithPlayerFlag(i, u, 0);
								Logic.SetShareExplorationWithPlayerFlag(u, i, 0);				
							end
						end
					end					
				end
			end
		end	
		mpc_TRIB_SelectView = function (_pId)
			AllowView[_pId] = not AllowView[_pId]
			PlayerViewChoosen(_pId)
		end
		PlayerViewChoosen = function(_pId)
			for i = 1,8 do
				for u = 1,8 do
					if not((mpc_MultiplayerPlaying[i] and mpc_MultiplayerPlaying[u]) or (i==u)) then
						if mpc_playerteams[i] == mpc_playerteams[u] then
							if mpc_MultiplayerPlaying[i] then
								if AllowView[i] then
									Logic.SetShareExplorationWithPlayerFlag(i, u, 1);
									Logic.SetShareExplorationWithPlayerFlag(u, i, 1);
								else
									Logic.SetShareExplorationWithPlayerFlag(i, u, 0);
									Logic.SetShareExplorationWithPlayerFlag(u, i, 0);				
								end
							end
						end					
					end
				end
			end	
			mpc_CreatePlayerViewTributes(_pId) 
		end
		
		mpc_CreatePlayerViewTributes = function(_pId)
			local _text = ""
			if AllowView[_pId] then
				_text = gvCol.rot.." Forbit watching you!"
			else
				_text = gvCol.gruen.." Allow watching you!"
			end	
			return AddTribute( CreateATribute(_pId, _text, { Gold = 0}, mpc_TRIBRuleFunc.view[_pId] ) )	
		end
		for i = 1,8 do
			if mpc_MultiplayerPlaying[i] then
				mpc_CreatePlayerViewTributes(i)
				mpc_CreatePlayerReadAllTributes(i)	
				mpc_CreatePlayerReadTributes(i)	
			end
		end
	end	
	
	AllowWeatherAgain = function()
		for i=1,8 do
			AllowTechnology(Technologies.T_MakeRain, i);
			AllowTechnology(Technologies.T_MakeSummer, i);
			AllowTechnology(Technologies.T_MakeSnow, i);
		end		
	end
	
	WeatherChangeLimitCountdownID = 0	
	ActionOnWeatherChange = function()
		if mpc_Rules["Weathermin"][mpc_Rules["Weathermin"].Cur] >= 0 then
			for i=1,8 do
				ForbidTechnology(Technologies.T_MakeRain, i);
				ForbidTechnology(Technologies.T_MakeSummer, i);
				ForbidTechnology(Technologies.T_MakeSnow, i);
			end
			StopCountdown(WeatherChangeLimitCountdownID)
			WeatherChangeLimitCountdownID = StartCountdown( mpc_Rules["Weathermin"][mpc_Rules["Weathermin"].Cur] * 60, AllowWeatherAgain, false )
		end
	end	
		
	Trigger.RequestTrigger( Events.LOGIC_EVENT_WEATHER_STATE_CHANGED, "", "ActionOnWeatherChange", 1)	
	mpc_TRIB_Setup()
	SetupRulesetComfort_Localization()
	MPC_Start()
	
	-- Bei Spielern ohne HQ die Verloren Nachricht ausblenden!
	mpc_HideLooseMsgForNotPlayersCounter = 2
	mpc_HideLooseMsgForNotPlayers = function()
		mpc_HideLooseMsgForNotPlayersCounter = mpc_HideLooseMsgForNotPlayersCounter -1
		if mpc_HideLooseMsgForNotPlayersCounter == 0 then
			if not(mpc_MultiplayerPlaying[gv_guipId]) then
				GUIAction_ToggleMenu(600,0)
			end
			return true
		end
	end
	StartSimpleJob("mpc_HideLooseMsgForNotPlayers")
end

-- Trigger
function ActionOnGoodsTraded()
	_player = GetPlayer( Event.GetEntityID() )
	_ressourcesell = Event.GetSellResource()
	_ressourcebuy = Event.GetBuyResource()
	if Logic.GetCurrentPrice(_player,_ressourcesell) > 1.5 then
			   Logic.SetCurrentPrice( _player, _ressourcesell, 1.5 )
	end
	if Logic.GetCurrentPrice(_player,_ressourcesell) < 0.5 then
			   Logic.SetCurrentPrice( _player, _ressourcesell, 0.5 )
	end
	if Logic.GetCurrentPrice(_player,_ressourcebuy) > 1.5 then
			   Logic.SetCurrentPrice( _player, _ressourcebuy, 1.5 )
	end
	if Logic.GetCurrentPrice(_player,_ressourcebuy) < 0.5 then
				Logic.SetCurrentPrice( _player, _ressourcebuy, 0.5 )
	end
end

function ActionOnEntityCreated()
	local _eId = Event.GetEntityID()
	local _eType = Logic.GetEntityType( _eId )
	if _eType == Entities.PB_VillageCenter1 then		
		if (mpc_Rules["Special1"].Act[3] or mpc_Rules["Special1"].Act[4]) then
			CheckVillageCenterNoReplaceMent(_eId)
		end
		if mpc_GameStartDelay <= 0 then
			NoRushRuleCheck(GetPlayer(_eId))
		end
	end
end

function ActionOnEntityDestroyed()
	local _eId = Event.GetEntityID()
	local _eType = Logic.GetEntityType( _eId )
	if ( _eType == Entities.PB_VillageCenter1 or _eType == Entities.PB_VillageCenter2 or _eType == Entities.PB_VillageCenter3 ) then
		if mpc_GameStartDelay <= 0 then
			NoRushRuleCheck( GetPlayer(_eId))
		end
	end
end

function StatisticLogging()
	
	StatisticsLog = {}
	StatisticsLog.Iron = {}
	StatisticsLog.Stone = {}
	StatisticsLog.Wood = {}
	StatisticsLog.Clay = {}
	StatisticsLog.Gold = {}
	StatisticsLog.Sulfur = {}
	StatisticsLog.Soldiers = {}
	StatisticsLog.Serfs = {}
	StatisticsLog.Workers = {}
	StatisticsLog.SleepPlace = {}
	StatisticsLog.EatPlace = {}
	StatisticsLog.TributeId = 0
	for i = 1,8 do
		StatisticsLog.Iron[i] = {}
		StatisticsLog.Stone[i] = {}
		StatisticsLog.Wood[i] = {}
		StatisticsLog.Clay[i] = {}
		StatisticsLog.Gold[i] = {}
		StatisticsLog.Sulfur[i] = {}
		StatisticsLog.Soldiers[i] = {}
		StatisticsLog.Serfs[i] = {}
		StatisticsLog.Workers[i] = {}
		StatisticsLog.SleepPlace[i] = {}
		StatisticsLog.EatPlace[i] = {}
	end
	StatisticsLog.PlayerEndGame = {}
	StatisticsLog.PlayerEndGame.Time = {0,0,0,0,0,0,0,0}
	StatisticsLog.PlayerEndGame.State = {0,0,0,0,0,0,0,0}	
	StatisticsLog.GameOver = false
	
	
	StatisticsLog.PlayerNames = {"","","","","","","",""}
	StatisticsLog.PlayerTeams = {0,0,0,0,0,0,0,0}
	for i = 1,8 do
		StatisticsLog.PlayerNames[i] = XNetwork.GameInformation_GetLogicPlayerUserName(i)
		StatisticsLog.PlayerTeams[i] = mpc_playerteams[i]
	end

	StatisticLogStartLogging = function()
		StatisticsLog.GameStartTime = Logic.GetTime()
		NextStatisticLog = StatisticsLog.Timer + Logic.GetTime()
		LogCurrentStatistic()
		StatisticLogJobId = StartSimpleJob("StatisticLogJob")
	end
	PlayerEndGame = function(_pId)
		StatisticsLog.PlayerEndGame.Time[_pId] = Logic.GetTime() - StatisticsLog.GameStartTime
		StatisticsLog.PlayerEndGame.State[_pId] = Logic.PlayerGetGameState(_pId)
		if StatisticsLog.PlayerEndGame.State[_pId] == 2 then
			if not StatisticsLog.GameOver then
				LogCurrentStatistic()
				StatisticsLog.GameOver = true
			end
		end
	end			
	
	GetNumberOfSoldiers = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfAttractedSoldiers(_pId)
		end
		return _nr
	end
	GetNumberOfSerfs = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfEntitiesOfTypeOfPlayer(_pId, Entities.PU_Serf)
		end	
		return _nr	
	end
	GetNumberOfSettlers = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfAttractedSettlers(_pId)
		end
		return _nr		
	end
	GetNumberOfWorkerWithoutEatPlace = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfWorkerWithoutEatPlace(_pId)
		end
		return _nr		
	end
	GetNumberOfWorkerWithoutSleepPlace = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfWorkerWithoutSleepPlace(_pId)
		end
		return _nr		
	end
	
	StatisticLogJob = function()
		if Logic.GetTime() >= NextStatisticLog then	
			NextStatisticLog = NextStatisticLog + StatisticsLog.Timer
			LogCurrentStatistic()
		end
	end
	LogCurrentStatistic = function()
		local _soliders = GetNumberOfSoldiers()
		local _serfs = GetNumberOfSerfs()
		local _settlers = GetNumberOfSettlers()
		local _workers = {}
		local _noeatplaces = GetNumberOfWorkerWithoutEatPlace()
		local _nosleepplaces = GetNumberOfWorkerWithoutSleepPlace()
		local _eatplaces = {}
		local _sleepplaces = {}
		local _gold = {}
		local _clay = {}
		local _wood = {}
		local _stone = {}
		local _iron = {}
		local _sulfur = {}		
		for i = 1 ,8 do
			_workers[i] = _settlers[i] - _serfs[i] - _soliders[i]
			_eatplaces[i] = _workers[i] - _noeatplaces[i]
			_sleepplaces[i] = _workers[i] - _nosleepplaces[i]
			_gold[i] = GetGold(i)
			_clay[i] = GetClay(i)
			_wood[i] = GetWood(i)
			_stone[i] = GetStone(i)
			_iron[i] = GetIron(i)
			_sulfur[i] = GetSulfur(i)		
		end
		for i = 1,8 do
			table.insert(StatisticsLog.Gold[i], _gold[i])		
			table.insert(StatisticsLog.Clay[i], _clay[i])	
			table.insert(StatisticsLog.Wood[i], _wood[i])	
			table.insert(StatisticsLog.Stone[i], _stone[i])		
			table.insert(StatisticsLog.Iron[i], _iron[i])		
			table.insert(StatisticsLog.Sulfur[i], _sulfur[i])
			table.insert(StatisticsLog.Soldiers[i], _soliders[i])
			table.insert(StatisticsLog.Serfs[i], _serfs[i])
			table.insert(StatisticsLog.Workers[i], _workers[i])
			table.insert(StatisticsLog.SleepPlace[i], _sleepplaces[i])
			table.insert(StatisticsLog.EatPlace[i], _eatplaces[i])
		end
	end
	StatisticsStringOutPut = function()
		XNetwork.Manager_RestartAsServer_SinglePlayer()
		EndJob(StatisticLogJobId)
		gv_StatisticsWaitSeconds = 2
		StatisticsOutputJobId = StartSimpleJob("StatisticsOutputJob")	
	end

	function StatisticsOutputAllBriefing()
		local briefing = {}
		local AP = function( _page ) table.insert( briefing, _page ); return _page; end
	 
		-- Seite 1
		local choicePage = AP{ 			
			mc 	 = {					
				title	= "Statistikausgabe",
				text 	= "Moechtest du erweiterte Statistiken ausgeben? Achtung! Dies kann eine lange Prozedur sein!",
				firstText   = "Ja",
				secondText  = "Nein",
				firstSelected  = 2,   -- Regen   -> Seite 2
				secondSelected = 4,   -- Schnee -> Seite 4
			},
			dialogCamera	=	true,
		}
		AP{text = "Los gehts...",}
		AP()
		AP{ text = "Du kannst das Spiel jetzt verlassen...",}
		briefing.finished =
			function()
				if GetSelectedBriefingMCButton( choicePage ) == 1 then -- Erste Antwort gewhlt?
					StatisticsOutputJobId = StartSimpleJob( "StatisticsOutputJob" )
				end
			end
		StartBriefing( briefing)
		-- soll dieses Briefing nicht aus einer anderen Funktion heraus aufgerufen werden,
		-- kann hier statt StartBriefing auch ein NPC erzeugt werden
	 
	end

	StatisticsLog.OutPutRow = {"Gold","Clay","Wood","Stone","Iron","Sulfur","Soldiers","Serfs","Workers","SleepPlace","EatPlace"}
	StatisticsLog.FirstNew = true
	StatisticsLog.CurrentText = ""
	StatisticsLog.CurrentNotDone = true
	StatisticsLog.CurrentOutput = 1
	StatisticsLog.CurrentRow = 1
	StatisticsLog.GeneralGameInfoOutputted = false
	enter=string.char(13)
	tab=string.char(9)
	StatisticsLog.outputstring = enter

	StatisticsOutputJob = function()

		if gv_StatisticsWaitSeconds == 0 then
			if not (StatisticsLog.GeneralGameInfoOutputted) then
				-------- ALLGEMEINE SPIELSTATISTIKEN AUSGABE ---------
				StatisticsLog.GeneralGameInfoOutputted = true
				local _Spieler = "Spieler:"
				local _Teams = "Team:"
				local _SpielEndeZeit = "Spielende bei:"
				local _SpielEndeStatus = "Status:"
				for i = 1,8 do
					if not (StatisticsLog.PlayerNames[i] == "") then
						_Spieler = _Spieler..tab..StatisticsLog.PlayerNames[i]
						_Teams = _Teams..tab..StatisticsLog.PlayerTeams[i]
						if not (StatisticsLog.PlayerEndGame.Time[i] == 0) then
							_SpielEndeZeit = _SpielEndeZeit..tab..math.floor(StatisticsLog.PlayerEndGame.Time[i] / 60)..". Minute"
						else
							_SpielEndeZeit = _SpielEndeZeit..tab.."nicht ermittelt!"
						end
						if StatisticsLog.PlayerEndGame.State[i] == 2 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."Win"
						elseif StatisticsLog.PlayerEndGame.State[i] == 3 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."Lost"
						elseif StatisticsLog.PlayerEndGame.State[i] == 0 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."nicht ermittelt!"
						elseif StatisticsLog.PlayerEndGame.State[i] == 4 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."Quitted"
						end		
					end
				end
				StatisticsLog.outputstring = StatisticsLog.outputstring.._Spieler..enter.._Teams..enter.._SpielEndeZeit..enter.._SpielEndeStatus..enter
				EndJob( StatisticsOutputJobId )
				StatisticsOutputAllBriefing()
				assert(false,StatisticsLog.outputstring)
			else
				-------- RESOURCEN AUSGABE ---------
				StatisticsLog.outputstring = StatisticsLog.CurrentText				
				if StatisticsLog.FirstNew then
					StatisticsLog.outputstring = enter..StatisticsLog.OutPutRow[StatisticsLog.CurrentOutput]
					for _pId = 1,8 do			
						if not (StatisticsLog.PlayerNames[_pId] == "") then
							StatisticsLog.outputstring = StatisticsLog.outputstring..tab..StatisticsLog.PlayerNames[_pId]
						end
					end
					StatisticsLog.outputstring = StatisticsLog.outputstring..enter
					StatisticsLog.FirstNew = false
				end
				for u = StatisticsLog.CurrentRow, table.getn (StatisticsLog.Gold[1]) do
					StatisticsLog.CurrentText = StatisticsLog.Timer * (u-1)
					for _pId = 1,8 do
						if not (StatisticsLog.PlayerNames[_pId] == "") then
							StatisticsLog.CurrentText = StatisticsLog.CurrentText..tab..StatisticsLog[StatisticsLog.OutPutRow[StatisticsLog.CurrentOutput]][_pId][u]
						end
					end
					StatisticsLog.CurrentText = StatisticsLog.CurrentText..enter
					if ( string.len(StatisticsLog.outputstring) + string.len(StatisticsLog.CurrentText) ) > 750 then
							StatisticsLog.CurrentRow = u + 1
							StatisticsLog.CurrentText = StatisticsLog.CurrentText
							assert(false,StatisticsLog.outputstring)-- Hier kommt der Abbruch, aber die Liste ist noch nicht fertig
					else
						StatisticsLog.outputstring = StatisticsLog.outputstring..StatisticsLog.CurrentText
						StatisticsLog.CurrentText = ""
					end				
				end
				StatisticsLog.CurrentOutput = StatisticsLog.CurrentOutput + 1
				if StatisticsLog.CurrentOutput > table.getn (StatisticsLog.OutPutRow) then
					EndJob( StatisticsOutputJobId )
				end
				StatisticsLog.CurrentRow = 1
				StatisticsLog.CurrentText = ""
				StatisticsLog.FirstNew = true
				assert(false,StatisticsLog.outputstring)			
			end
		end
		gv_StatisticsWaitSeconds = gv_StatisticsWaitSeconds - 1		
	end
	if StatisticsLog.PlayerNames[1] == "" then
		StatisticsLog.PlayerNames[1] = UserTool_GetPlayerName(1)
		AddTribute( CreateATribute(gv_guipId, "Spielstatistiken ausgeben (Achtung, du verlaesst dadurch das Spiel!)", { Gold = 0}, StatisticsStringOutPut ) )
	end	
	StatisticsLog.Timer = 30

end

function SetupWalls()		
	local _enter=string.char(13)
	table.insert(GUITooltip_ConstructBuilding_BeforeOrig,
		function(...)			
			if arg[1] == 31 then
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Mauer @cr @color:255,255,255 Errichtet eine Mauer fr eure Siedlung. Bei der Fertigstellung kostet diese Extraressourcen. Eure Siedler fhlen sich sicherer (Motivationsschub)." )
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 100 @cr Lehm: 100" )
				return false
			elseif arg[1] == 28 then
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Tor @cr @color:255,255,255 Errichtet ein Tor fr eure Schutzmauern. Eure Siedler fhlen sich sicherer (Motivationsschub)." )
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 200 @cr Stein: 100" )
				return false
			elseif arg[1] == 66 then
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Abschlussmauer @cr @color:255,255,255 Errichtet eine Abschlussmauer um Mauerteile zu verbinden oder eine Mauer ber die Baugrenzen hinaus zu erweitern. Eure Siedler fhlen sich sicherer (Motivationsschub)." )
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 300 @cr Stein: 100" )
				return false
			elseif arg[1] == 30 then
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Mauerturm @cr @color:255,255,255 Errichtet einen Ballistaturm der direkt in der nahesten Mauer platziert wird. Eure Siedler fhlen sich sicherer (Motivationsschub)." )
				XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 400 @cr Stein: 200" )
				return false
			end
		end
	)

    -- Model ersetzen wenn Mauer errichtet wird
	WallsOnEntityCreated = function()
		local _eId = Event.GetEntityID()
		local _pId = GetPlayer(_eId)
		local _eType = Logic.GetEntityType(_eId)
		if _eType == Entities.PB_Beautification04  then
			Logic.SetModelAndAnimSet(_eId,Models.XD_WallStraight)
		elseif _eType == Entities.PB_Beautification01  then
			Logic.SetModelAndAnimSet(_eId,Models.XD_WallStraightGate)
		elseif _eType == Entities.PB_Beautification05  then
			Logic.SetModelAndAnimSet(_eId,Models.XD_DarkWallDistorted)
		elseif _eType == Entities.PB_Beautification03  then
			Logic.SetModelAndAnimSet(_eId,Models.PB_DarkTower2)
		end
	end
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "WallsOnEntityCreated", 1)
	SelfCreatedWalls = {}
	for i = 0,8 do
		SelfCreatedWalls[i] = {}
	end
	SelfCreatedWalls_PfostenSellTributeIDs = {}
	SetupWallsMauerplatzieren = function(_eId)		
		local _pId = GetPlayer(_eId)
		local _PfostenID = 0
		local _PfostenID2 = 0
		local _pos = GetPosition(_eId)
		local _eType = Logic.GetEntityType(_eId)
		if type(SelfCreatedWalls[_pId][_eId]) ~= "table" then	
			
			local _mauer = 0
			local _mauer2 = 0
			local _mauerecke1 = 0
			local _mauerecke2 = 0
			local _istMauer = true
			local _entfernung = 1200
			
			if _eType ~= Entities.PB_Beautification05 then
				for u = 1,3 do
					if u == 1 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraight, _pos.X, _pos.Y, 1200,16)}
					elseif u == 2 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraightGate, _pos.X, _pos.Y, 1200,16)}
					elseif u == 3 then  _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraightGate_Closed, _pos.X, _pos.Y, 1200,16)}
					end
					for i = 2, table.getn(_mauern) do
						local _distance = GetDistance(_mauern[i],_eId)
						if _distance < _entfernung and _distance > 0 and Logic.IsConstructionComplete(_mauern[i]) == 1  then
							_mauer = _mauern[i]
							_entfernung = _distance
						end
					end				
				end
			else
				for u = 1,3 do
					if u == 1 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraight, _pos.X, _pos.Y, 1200,16)}
					elseif u == 2 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraightGate, _pos.X, _pos.Y, 1200,16)}
					elseif u == 3 then  _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraightGate_Closed, _pos.X, _pos.Y, 1200,16)}
					end
					for i = 2, table.getn(_mauern) do
						local _distance = GetDistance(_mauern[i],_eId)			
						if _distance < _entfernung and _distance > 0 and Logic.IsConstructionComplete(_mauern[i]) == 1  then	
							local _orientation = Logic.GetEntityOrientation(_mauern[i])
							if _orientation < 90 then
								_orientation = 270 + _orientation
							else
								_orientation = _orientation - 90
							end	
							local _posMauer = GetPosition(_mauern[i])
							local _ecke1
							local _ecke2
							if _istMauer then
								_ecke1 = {X=_posMauer.X+math.cos(_orientation/360*math.pi*2) * 200,Y=_posMauer.Y+math.sin(_orientation/360*math.pi*2) * 200}
								_ecke2 = {X=_posMauer.X-math.cos(_orientation/360*math.pi*2) * 200,Y=_posMauer.Y-math.sin(_orientation/360*math.pi*2) * 200}
							else
								_ecke1 = {X=_posMauer.X+math.cos(_orientation/360*math.pi*2) * 300,Y=_posMauer.Y+math.sin(_orientation/360*math.pi*2) * 300}
								_ecke2 = {X=_posMauer.X-math.cos(_orientation/360*math.pi*2) * 300,Y=_posMauer.Y-math.sin(_orientation/360*math.pi*2) * 300}				
							end
							local _pfosten ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallCorner, _ecke1.X, _ecke1.Y, 100,16)}
							if _pfosten[1] == 0 then
								_mauer = _mauern[i]
								_entfernung = _distance
								_mauerecke1 = _ecke1
							else
								_pfosten ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallCorner, _ecke2.X, _ecke2.Y, 100,16)}
								if _pfosten[1] == 0 then
									_mauer = _mauern[i]
									_entfernung = _distance	
									_mauerecke1 = _ecke2							
								end
							end
						end
					end				
				end
				if _mauer > 0 then
					_entfernung = 1200
					for u = 1,3 do
						if u == 1 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraight, _pos.X, _pos.Y, 1200,16)}
						elseif u == 2 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraightGate, _pos.X, _pos.Y, 1200,16)}
						elseif u == 3 then  _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraightGate_Closed, _pos.X, _pos.Y, 1200,16)}
						end
						for i = 2, table.getn(_mauern) do
							local _distance = GetDistance(_mauern[i],_eId)		
							if _distance < _entfernung and _distance > 0 and Logic.IsConstructionComplete(_mauern[i]) == 1 then	
								local _orientation = Logic.GetEntityOrientation(_mauern[i])
								if _orientation < 90 then
									_orientation = 270 + _orientation
								else
									_orientation = _orientation - 90
								end	
								local _posMauer = GetPosition(_mauern[i])
								local _ecke1
								local _ecke2
								if _istMauer then
									_ecke1 = {X=_posMauer.X+math.cos(_orientation/360*math.pi*2) * 200,Y=_posMauer.Y+math.sin(_orientation/360*math.pi*2) * 200}
									_ecke2 = {X=_posMauer.X-math.cos(_orientation/360*math.pi*2) * 200,Y=_posMauer.Y-math.sin(_orientation/360*math.pi*2) * 200}
								else
									_ecke1 = {X=_posMauer.X+math.cos(_orientation/360*math.pi*2) * 300,Y=_posMauer.Y+math.sin(_orientation/360*math.pi*2) * 300}
									_ecke2 = {X=_posMauer.X-math.cos(_orientation/360*math.pi*2) * 300,Y=_posMauer.Y-math.sin(_orientation/360*math.pi*2) * 300}				
								end
								local _pfosten ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallCorner, _ecke1.X, _ecke1.Y, 100,16)}
								if _pfosten[1] == 0 and not(_mauerecke1.X == _ecke1.X and _mauerecke1.Y == _ecke1.Y) then
									if GetDistance(_ecke1,_mauerecke1) <= 615 then
										_mauer2 = _mauern[i]
										_entfernung = _distance
										_mauerecke2 = _ecke1
									end
								else
									_pfosten ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallCorner, _ecke2.X, _ecke2.Y, 100,16)}
									if _pfosten[1] == 0 and not(_mauerecke1.X == _ecke2.X and _mauerecke1.Y == _ecke2.Y)  then
										if GetDistance(_ecke2,_mauerecke1) <= 615 then
											_mauer2 = _mauern[i]
											_entfernung = _distance
											_mauerecke2 = _ecke2
										end
									end
								end
							end
						end				
					end				
				end
			end
			
			if _mauer > 0 then
				if _mauerecke1 == 0 then
					local _ecke
					_orientation = Logic.GetEntityOrientation(_mauer)
					if _orientation < 90 then
						_orientation = 270 + _orientation
					else
						_orientation = _orientation - 90
					end		
					local _posMauer = GetPosition(_mauer)
					local _ecke1
					local _ecke2
					if _istMauer then
						_ecke1 = {X=_posMauer.X+math.cos(_orientation/360*math.pi*2) * 200,Y=_posMauer.Y+math.sin(_orientation/360*math.pi*2) * 200}
						_ecke2 = {X=_posMauer.X-math.cos(_orientation/360*math.pi*2) * 200,Y=_posMauer.Y-math.sin(_orientation/360*math.pi*2) * 200}
					else
						_ecke1 = {X=_posMauer.X+math.cos(_orientation/360*math.pi*2) * 300,Y=_posMauer.Y+math.sin(_orientation/360*math.pi*2) * 300}
						_ecke2 = {X=_posMauer.X-math.cos(_orientation/360*math.pi*2) * 300,Y=_posMauer.Y-math.sin(_orientation/360*math.pi*2) * 300}				
					end
					
					if GetDistance(_pos,_ecke1) > GetDistance(_pos,_ecke2) then
						_ecke = _ecke2
					else
						_ecke = _ecke1
					end
					_orientation = Winkel(_ecke,_eId)
					local _newPos
					if _eType == Entities.PB_Beautification04 then
						_newPos = {X=_ecke.X+math.cos((_orientation)/360*math.pi*2) * 200,Y=_ecke.Y+math.sin((_orientation)/360*math.pi*2) * 200}
					else
						_newPos = {X=_ecke.X+math.cos((_orientation)/360*math.pi*2) * 300,Y=_ecke.Y+math.sin((_orientation)/360*math.pi*2) * 300}
					end
					if _orientation < 90 then
						_orientation = 270 + _orientation
					else
						_orientation = _orientation - 90
					end				
					DestroyEntity(_eId)
					if _eType == Entities.PB_Beautification04 then
						_eId = Logic.CreateEntity( Entities.XD_WallStraight, _newPos.X, _newPos.Y, _orientation, _pId )
					else
						_eId = Logic.CreateEntity( Entities.XD_WallStraightGate, _newPos.X, _newPos.Y, _orientation, _pId )
					end
					_PfostenID = Logic.CreateEntity( Entities.XD_WallCorner, _ecke.X, _ecke.Y, 0, _pId )
				else
					if _mauerecke2 == 0 then
						_orientation = Winkel(_mauer,_mauerecke1)
						local _newPos = {X=_mauerecke1.X+math.cos((_orientation)/360*math.pi*2) * 285,Y=_mauerecke1.Y+math.sin((_orientation)/360*math.pi*2) * 285}
						_ecke1 = {X=_newPos.X+math.cos(_orientation/360*math.pi*2) * 290,Y=_newPos.Y+math.sin(_orientation/360*math.pi*2) * 290}
						_ecke2 = {X=_newPos.X-math.cos(_orientation/360*math.pi*2) * 290,Y=_newPos.Y-math.sin(_orientation/360*math.pi*2) * 290}						
						if _orientation < 135 then
							_orientation = 270 + _orientation - 45
						else
							_orientation = _orientation - 90 - 45
						end				
						DestroyEntity(_eId)
						_eId = Logic.CreateEntity( Entities.XD_WallDistorted, _newPos.X, _newPos.Y, _orientation, _pId )
						
						_PfostenID = Logic.CreateEntity( Entities.XD_WallCorner, _ecke1.X, _ecke1.Y, 0, _pId )
						_PfostenID2 = Logic.CreateEntity( Entities.XD_WallCorner, _ecke2.X, _ecke2.Y, 0, _pId )
					else
						_orientation = Winkel(_mauerecke1,_mauerecke2)
						local _newPos = {X=_mauerecke1.X+math.cos((_orientation)/360*math.pi*2) * 285,Y=_mauerecke1.Y+math.sin((_orientation)/360*math.pi*2) * 285}
						_ecke1 = {X=_newPos.X+math.cos(_orientation/360*math.pi*2) * 290,Y=_newPos.Y+math.sin(_orientation/360*math.pi*2) * 290}
						_ecke2 = {X=_newPos.X-math.cos(_orientation/360*math.pi*2) * 290,Y=_newPos.Y-math.sin(_orientation/360*math.pi*2) * 290}						
						if _orientation < 135 then
							_orientation = 270 + _orientation - 45
						else
							_orientation = _orientation - 90 - 45
						end				
						DestroyEntity(_eId)
						_eId = Logic.CreateEntity( Entities.XD_WallDistorted, _newPos.X, _newPos.Y, _orientation, _pId )
						_PfostenID = Logic.CreateEntity( Entities.XD_WallCorner, _ecke1.X, _ecke1.Y, 0, _pId )
						_PfostenID2 = Logic.CreateEntity( Entities.XD_WallCorner, _ecke2.X, _ecke2.Y, 0, _pId )
					end
				end
			else
				DestroyEntity(_eId)
				if _eType == Entities.PB_Beautification04 then
					_eId = Logic.CreateEntity( Entities.XD_WallStraight, _pos.X, _pos.Y, 0, _pId )
				elseif  _eType == Entities.PB_Beautification01 then
					_eId = Logic.CreateEntity( Entities.XD_WallStraightGate, _pos.X, _pos.Y, 0, _pId )
				elseif  _eType == Entities.PB_Beautification05 then
					_eId = Logic.CreateEntity( Entities.XD_WallDistorted, _pos.X, _pos.Y, 0, _pId )
				end
			end
			SelfCreatedWalls[_pId][_eId] = {}
			SelfCreatedWalls[_pId][_eId].ID = _eId
			function GetSellTributCallback(_pId,_eId)
				local myfunc = function()
					local _pos = GetPosition(_eId)
					DestroyEntity(SelfCreatedWalls[_pId][_eId].ID)
					Tools.GiveResouces(_pId, 100, nil, nil, nil, nil, nil)
					Logic.CreateEffect( GGL_Effects.FXBuildingSmoke, _pos.X, _pos.Y, _pId );
				end
				return myfunc
			end
			function GetSellTributCallbackPfosten(_pId,_eId)
				local myfunc = function()
					local _pos = GetPosition(_eId)
					DestroyEntity(_eId)
					Logic.CreateEffect( GGL_Effects.FXBuildingSmoke, _pos.X, _pos.Y, _pId );
				end
				return myfunc
			end
			function GetCloseTributCallback(_pId,_eId)
				local myfunc = function()
					local _eType = Logic.GetEntityType(_eId)
					local _eIdNew =_eId
					local _oldHealth
					if _eType == Entities.XD_WallStraightGate then
						_oldHealth = Logic.GetEntityHealth(_eId)
						_eIdNew = ReplaceEntity (_eId, Entities.XD_WallStraightGate_Closed )
						Logic.HurtEntity(_eIdNew,Logic.GetEntityMaxHealth(_eIdNew)-_oldHealth)
					elseif _eType == Entities.XD_WallStraightGate_Closed then
						_oldHealth = Logic.GetEntityHealth(_eId)
						_eIdNew = ReplaceEntity (_eId, Entities.XD_WallStraightGate )
						Logic.HurtEntity(_eIdNew,Logic.GetEntityMaxHealth(_eIdNew)-_oldHealth)
					end
					if _eIdNew ~= _eId then
						SelfCreatedWalls[_pId][_eIdNew] = SelfCreatedWalls[_pId][_eId]
						SelfCreatedWalls[_pId][_eIdNew].ID = _eIdNew
						MakeInvulnerable(_eIdNew)
						SelfCreatedWalls[_pId][_eIdNew].SellTributID = AddTribute( CreateATribute(8, "", { Gold = 0}, GetSellTributCallback(_pId,_eIdNew) ) )
						SelfCreatedWalls[_pId][_eIdNew].CloseTributID = AddTribute( CreateATribute(8, "", { Gold = 0}, GetCloseTributCallback(_pId,_eIdNew) ) )
					end
				end
				return myfunc
			end
			SelfCreatedWalls[_pId][_eId].CloseTributID = AddTribute( CreateATribute(8, "", { Gold = 0}, GetCloseTributCallback(_pId,_eId) ) )	
			SelfCreatedWalls[_pId][_eId].SellTributID = AddTribute( CreateATribute(8, "", { Gold = 0}, GetSellTributCallback(_pId,_eId) ) )	
			SelfCreatedWalls[_pId][_eId].Pfosten = _PfostenID
			SelfCreatedWalls[_pId][_eId].Pfosten2 = _PfostenID2
			SelfCreatedWalls_PfostenSellTributeIDs[_PfostenID]  = AddTribute( CreateATribute(8, "", { Gold = 0}, GetSellTributCallbackPfosten(_pId,_PfostenID) ) )
			SelfCreatedWalls_PfostenSellTributeIDs[_PfostenID2]  = AddTribute( CreateATribute(8, "", { Gold = 0}, GetSellTributCallbackPfosten(_pId,_PfostenID2) ) )			
			MakeInvulnerable(_eId)
			MakeInvulnerable(_PfostenID)
			MakeInvulnerable(_PfostenID2)
		end
		return true
	end	
	SetupWallsTurmplatzieren = function(_eId)		
		local _pId = GetPlayer(_eId)
		local _pos = GetPosition(_eId)
		local _eType = Logic.GetEntityType(_eId)			
		local _mauer = 0
		local _entfernung = 1200
		for u = 1,2 do
			if u == 1 then _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallStraight, _pos.X, _pos.Y, 1200,16)}
			elseif u == 2 then  _mauern ={Logic.GetPlayerEntitiesInArea(_pId,Entities.XD_WallDistorted, _pos.X, _pos.Y, 1200,16)}
			end
			for i = 2, table.getn(_mauern) do
				local _distance = GetDistance(_mauern[i],_eId)
				if _distance < _entfernung and _distance > 0 and Logic.IsConstructionComplete(_mauern[i]) == 1  then
					local _mauerpos = GetPosition(_mauern[i])
					local _turm ={Logic.GetPlayerEntitiesInArea(_pId,Entities.PB_DarkTower2, _mauerpos.X, _mauerpos.Y, 100,16)}
					if _turm[1] <= 0 then
						local _turm ={Logic.GetPlayerEntitiesInArea(_pId,Entities.PB_DarkTower3, _mauerpos.X, _mauerpos.Y, 100,16)}
						if _turm[1] <= 0 then
							_mauer = _mauern[i]
							_entfernung = _distance						
						end
					end
				end
			end				
		end
		if _mauer ~= 0 then
			local _posMauer = GetPosition(_mauer)
			DestroyEntity(_eId)
			Logic.CreateEntity( Entities.PB_DarkTower2, _posMauer.X+1, _posMauer.Y+1, 0, _pId )
		else
			DestroyEntity(_eId)
			Logic.CreateEntity( Entities.PB_DarkTower2, _pos.X+1, _pos.Y+1, 0, _pId )			
		end
		return true
	end
	SetupWallsWallDestroyed = function()
		local _eId = Event.GetEntityID()
		local _pId = GetPlayer(_eId)
		if type(SelfCreatedWalls[_pId][_eId]) == "table" then
			MakeVulnerable(SelfCreatedWalls[_pId][_eId].Pfosten)
			DestroyEntity(SelfCreatedWalls[_pId][_eId].Pfosten)
			MakeVulnerable(SelfCreatedWalls[_pId][_eId].Pfosten2)
			DestroyEntity(SelfCreatedWalls[_pId][_eId].Pfosten2)
			Logic.RemoveTribute( 8, SelfCreatedWalls[_pId][_eId].SellTributID)
			Logic.RemoveTribute( 8, SelfCreatedWalls_PfostenSellTributeIDs[SelfCreatedWalls[_pId][_eId].Pfosten])
			Logic.RemoveTribute( 8, SelfCreatedWalls_PfostenSellTributeIDs[SelfCreatedWalls[_pId][_eId].Pfosten2])
			Logic.RemoveTribute( 8, SelfCreatedWalls[_pId][_eId].CloseTributID)			
			table.remove(SelfCreatedWalls[_pId], _eId)
		end
	end
	table.insert(GameCallback_OnBuildingConstructionComplete_AfterOrig,
		function(_eId,_pId)
			local _eType = Logic.GetEntityType(_eId)
			if _eType == Entities.PB_Beautification04 then
				StartSimpleJob(SetupWallsMauerplatzieren,_eId)
			elseif _eType == Entities.PB_Beautification01  then
				StartSimpleJob(SetupWallsMauerplatzieren,_eId)
			elseif _eType == Entities.PB_Beautification05  then
				StartSimpleJob(SetupWallsMauerplatzieren,_eId)
			elseif _eType == Entities.PB_Beautification03  then -- turm
				StartSimpleJob(SetupWallsTurmplatzieren,_eId)
			end
		end
	)
	table.insert(GameCallback_GUI_SelectionChanged_AfterOrig,
		function(...)
			local _eType = Logic.GetEntityType(GUI.GetSelectedEntity())
			if _eType == Entities.PB_DarkTower2 then
				XGUIEng.ShowWidget( 1141, 1);
				XGUIEng.ShowWidget( 1143, 0);
				XGUIEng.ShowWidget( 1144, 1);
			end
		end
	)
	
	table.insert(GUI.SellBuilding_AfterOrig,
		function()
			if type(SelfCreatedWalls[gv_guipId][GUI.GetSelectedEntity()]) == "table" then
				GUI.PayTribute( 8, SelfCreatedWalls[gv_guipId][GUI.GetSelectedEntity()].SellTributID)
			elseif SelfCreatedWalls_PfostenSellTributeIDs[GUI.GetSelectedEntity()] ~= nil then
				Message("jo")
				GUI.PayTribute( 8, SelfCreatedWalls_PfostenSellTributeIDs[GUI.GetSelectedEntity()])
			end
			table.remove(SelfCreatedWalls[gv_guipId], GUI.GetSelectedEntity())
		end
	)

	table.insert(GUIAction_DoNotDestroyBuilding_BeforeOrig,
		function()
			if type(SelfCreatedWalls[gv_guipId][GUI.GetSelectedEntity()]) == "table" then				
				GUI.PayTribute( 8, SelfCreatedWalls[gv_guipId][GUI.GetSelectedEntity()].CloseTributID)
			end
		end
	)
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_DESTROYED, "", "SetupWallsWallDestroyed", 1)
    XGUIEng.TransferMaterials(996 , 799 )  --Mauer
	XGUIEng.TransferMaterials(837 , 796 )   --Tor
	XGUIEng.TransferMaterials(1140 , 800 )   --Abschlussmauer
	XGUIEng.TransferMaterials(827 , 798 )   --MauerTurm
	-- ########################
	-- ### Comfort Mauer Rstung by Noigi
	WALL_ARMOR = 15;
	WALL_ARMOR_TECHBONUS = 5;
	GetWallArmor = function(_pID)
		local armor = WALL_ARMOR;
		if Logic.IsTechnologyResearched( _pID, Technologies.T_Masonry ) == 1 then
			armor = armor+WALL_ARMOR_TECHBONUS;
		end
		return armor;
	end

	Walls_ActionOnEntityHurt = function()
		local tarID = Event.GetEntityID2();
		local tarPlayer = GetPlayer( tarID )
		local tarType = Logic.GetEntityType(tarID);		
		if type(SelfCreatedWalls[tarPlayer][tarID]) == "table" then	
			local attID = Event.GetEntityID1();
			local attType = Logic.GetEntityType(attID);
			local ap = Logic.GetEntityDamage(attID);
			if ap > 22 then ap = 22 end
			if attType >= 207 and attType <= 214 then
				ap = ap*1.5
				if ap > 25 then ap = 25 end
			end
			local pID = GetPlayer(tarID);
			local def = GetWallArmor(pID);
			local dmg = math.max( ap-def, 1 );			
			local hp = Logic.GetEntityHealth(tarID);
			if hp > dmg then
				MakeVulnerable(tarID);
				Logic.HurtEntity(tarID,dmg);
				MakeInvulnerable(tarID);
			else
				MakeVulnerable(tarID);
				SetHealth(tarID,0);
			end
		end
	end
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_HURT_ENTITY, "", "Walls_ActionOnEntityHurt", 1);
	
	-- ########################
	-- ### Comfort Mauer Rstung GUI
	
	table.insert(GUIUpdate_Armor_BeforeOrig,
		function()
			local sel = GUI.GetSelectedEntity()
			local selType = Logic.GetEntityType(sel)
			if (selType == Entities.XD_WallStraightGate_Closed) or (selType == Entities.XD_WallStraightGate) or (selType == Entities.XD_WallStraight)  or (selType == Entities.XD_WallDistorted) then
				XGUIEng.SetText( XGUIEng.GetCurrentWidgetID(), "@ra "..GetWallArmor(GUI.GetPlayerID()) );
				return false
			end
		end
	)	
end

function CaptureTheFlagInit()

	CtF_Punkte = {}
	CtF_Helden = {}
	
	CtF_Ziele = {}
	CtF_Flagge = {}
	for i = 1,8 do
		CtF_Punkte[i] = 0
		CtF_Helden[i] = {}
	end
	CtF_HoldTimer = -1
	CtF_FlaggenhalterId = -1
	CtF_FlaggenhalterpId = -1
	CaptureTheFlagOnChoosen = function()
		table.insert(CtF_Flagge,GetEntityId(mpc_Rules["FlagRange"].FlagName))
		local _Flagpos = GetPosition(CtF_Flagge[1])
		ActionOnEntityCreatedCtF = function()
			local _eId = Event.GetEntityID()
			local _eType = Logic.GetEntityType( _eId )
			local _pId = GetPlayer(_eId)
			if mpc_Rules["FlagRange"].AllHeroes and Logic.IsHero(_eId) == 1 then
				table.insert(CtF_Helden[_pId],_eId)
			end
			if mpc_Rules["FlagRange"].HQ then
				if _eType == gv_Entities_HQs[1] or _eType == gv_Entities_HQs[2] or _eType == gv_Entities_HQs[3] then
					CtF_Ziele[_pId] = _eId
				end
			end
		end
		for _pId = 1,8 do
			if mpc_Rules["FlagRange"].HQ then
				for i = 1,3 do
					if table.getn(Track_Entity_Table[_pId][gv_Entities_HQs[i]]) > 0 then
						CtF_Ziele[_pId] = Track_Entity_Table[_pId][gv_Entities_HQs[i]][1]
					end
				end
			else
				CtF_Ziele[_pId] = GetEntityId("Ziel".._pId)
			end
			if not(mpc_Rules["FlagRange"].AllHeroes) then	
				table.insert(CtF_Helden[_pId],GetEntityId("Held".._pId))
			end
			Logic.SetEntityExplorationRange ( Logic.CreateEntity( Entities.XD_ScriptEntity, _Flagpos.X+_pId, _Flagpos.Y+_pId, 0, _pId ), 10 )
		end
		if mpc_Rules["FlagRange"].HQ or mpc_Rules["FlagRange"].AllHeroes then
			Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "ActionOnEntityCreatedCtF", 1)
		end
	end

	CaptureTheFlagJob = function()
		if CtF_HoldTimer < 0 then
			for pId=1,8 do  
				if CtF_HoldTimer > 0 then break end
				for i = 1, table.getn(CtF_Helden[pId]) do
					if CtF_HoldTimer > 0 then break end
					for u = 1, table.getn(CtF_Flagge) do
						if IsNear(CtF_Flagge[u],CtF_Helden[pId][i],mpc_Rules["FlagRange"].Flag) and not IsDead(CtF_Helden[pId][i]) then
							Message(mpc_playernames[pId].." "..gvCol.weiss.." (Team "..mpc_playerteams[pId].."): "..gvCol.gelb.." "..g_MC_Loc[lang].FlagNowHolding)
							CtF_FlaggenhalterId = CtF_Helden[pId][i]
							CtF_FlaggenhalterpId = GetPlayer(CtF_FlaggenhalterId)
							FanfareSound()
							StartCountdown( 1,FanfareSound, false )
							CtF_HoldTimer = mpc_Rules["FlagMaxHoldtime"][mpc_Rules["FlagMaxHoldtime"].Cur]
							break
						end
					end
				end
			end
		end
		if CtF_HoldTimer == 0 then
			Message(gvCol.rot.." "..g_MC_Loc[lang].FlagReset)
			CtF_HoldTimer = -1
			CtF_FlaggenhalterId = -1
			CtF_FlaggenhalterpId = -1		
		end  
		if CtF_HoldTimer > 0 then
			CtF_HoldTimer = CtF_HoldTimer - 1
			local _flagposition = GetPosition(CtF_FlaggenhalterId)
			GUI.ScriptSignal(_flagposition.X, _flagposition.Y, 2, 0 )
			if IsNear(CtF_Ziele[CtF_FlaggenhalterpId], CtF_FlaggenhalterId, mpc_Rules["FlagRange"].Dest) then  
				Message(mpc_playernames[CtF_FlaggenhalterpId].." "..gvCol.weiss.." (Team"..mpc_playerteams[CtF_FlaggenhalterpId].."): "..gvCol.gelb.." "..g_MC_Loc[lang].FlagCaptured)
				for _pId = 1, 8 do
					if mpc_playerteams[_pId] == mpc_playerteams[CtF_FlaggenhalterpId] then
						CtF_Punkte[_pId] = CtF_Punkte[_pId] + 1
					end
				end
				Message(gvCol.gelb.." Team"..mpc_playerteams[CtF_FlaggenhalterpId].." "..g_MC_Loc[lang].FlagScore..": "..gvCol.gruen.." "..CtF_Punkte[CtF_FlaggenhalterpId].." / "..gvCol.gelb.." "..mpc_Rules["FlagPoints"][mpc_Rules["FlagPoints"].Cur])
				if mpc_playerteams[gv_guipId] == mpc_playerteams[CtF_FlaggenhalterpId] then
					HeliasSound()
					StartCountdown( 1,HeliasSound, false )			
				else
					KerberosSound()
					StartCountdown( 1,KerberosSound, false )			
				end
				-- Wenn Punktestand erreicht werden die Hauptquartiere zerstrt
				if CtF_Punkte[CtF_FlaggenhalterpId] == mpc_Rules["FlagPoints"][mpc_Rules["FlagPoints"].Cur] then
					for _pId = 1, 8 do
						if not(mpc_playerteams[_pId] == mpc_playerteams[CtF_FlaggenhalterpId]) then
							CtF_Punkte[_pId] = CtF_Punkte[_pId] + 1
							for i = 1, table.getn( Track_Entity_Table[_pId][ Entities.PB_Headquarters1 ] ) do
								DestroyEntity (Track_Entity_Table[_pId][ Entities.PB_Headquarters1 ][1])
							end
							for i = 1, table.getn( Track_Entity_Table[_pId][ Entities.PB_Headquarters2 ] ) do
								DestroyEntity (Track_Entity_Table[_pId][ Entities.PB_Headquarters2 ][1])
							end
							for i = 1, table.getn( Track_Entity_Table[_pId][ Entities.PB_Headquarters3 ] ) do
								DestroyEntity (Track_Entity_Table[_pId][ Entities.PB_Headquarters3 ][1])
							end
						end
					end
				end
				CtF_HoldTimer = -1
				CtF_FlaggenhalterId = -1
				CtF_FlaggenhalterpId = -1
			end
			if CtF_HoldTimer >= 0 and IsDead(CtF_FlaggenhalterId) then
				CtF_HoldTimer = -1
				CtF_FlaggenhalterId = -1
				CtF_FlaggenhalterpId = -1
				Message(gvCol.rot.." "..g_MC_Loc[lang].FlagHolderDead)
			end
		end
	end
end

function StatisticLogging()
	
	StatisticsLog = {}
	StatisticsLog.Iron = {}
	StatisticsLog.Stone = {}
	StatisticsLog.Wood = {}
	StatisticsLog.Clay = {}
	StatisticsLog.Gold = {}
	StatisticsLog.Sulfur = {}
	StatisticsLog.Soldiers = {}
	StatisticsLog.Serfs = {}
	StatisticsLog.Workers = {}
	StatisticsLog.SleepPlace = {}
	StatisticsLog.EatPlace = {}
	StatisticsLog.TributeId = 0
	for i = 1,8 do
		StatisticsLog.Iron[i] = {}
		StatisticsLog.Stone[i] = {}
		StatisticsLog.Wood[i] = {}
		StatisticsLog.Clay[i] = {}
		StatisticsLog.Gold[i] = {}
		StatisticsLog.Sulfur[i] = {}
		StatisticsLog.Soldiers[i] = {}
		StatisticsLog.Serfs[i] = {}
		StatisticsLog.Workers[i] = {}
		StatisticsLog.SleepPlace[i] = {}
		StatisticsLog.EatPlace[i] = {}
	end
	StatisticsLog.PlayerEndGame = {}
	StatisticsLog.PlayerEndGame.Time = {0,0,0,0,0,0,0,0}
	StatisticsLog.PlayerEndGame.State = {0,0,0,0,0,0,0,0}	
	StatisticsLog.GameOver = false
	
	
	StatisticsLog.PlayerNames = {"","","","","","","",""}
	StatisticsLog.PlayerTeams = {0,0,0,0,0,0,0,0}
	for i = 1,8 do
		StatisticsLog.PlayerNames[i] = XNetwork.GameInformation_GetLogicPlayerUserName(i)
		StatisticsLog.PlayerTeams[i] = XNetwork.GameInformation_GetLogicPlayerTeam(i)
	end

	StatisticLogStartLogging = function()
		StatisticsLog.GameStartTime = Logic.GetTime()
		NextStatisticLog = StatisticsLog.Timer + Logic.GetTime()
		LogCurrentStatistic()
		StatisticLogJobId = StartSimpleJob("StatisticLogJob")
	end
	PlayerEndGame = function(_pId)
		StatisticsLog.PlayerEndGame.Time[_pId] = Logic.GetTime() - StatisticsLog.GameStartTime
		StatisticsLog.PlayerEndGame.State[_pId] = Logic.PlayerGetGameState(_pId)
		if StatisticsLog.PlayerEndGame.State[_pId] == 2 then
			if not StatisticsLog.GameOver then
				LogCurrentStatistic()
				StatisticsLog.GameOver = true
			end
		end
	end			
	
	GetNumberOfSoldiers = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfAttractedSoldiers(_pId)
		end
		return _nr
	end
	GetNumberOfSerfs = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfEntitiesOfTypeOfPlayer(_pId, Entities.PU_Serf)
		end	
		return _nr	
	end
	GetNumberOfSettlers = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfAttractedSettlers(_pId)
		end
		return _nr		
	end
	GetNumberOfWorkerWithoutEatPlace = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfWorkerWithoutEatPlace(_pId)
		end
		return _nr		
	end
	GetNumberOfWorkerWithoutSleepPlace = function()
		local _nr = {0,0,0,0,0,0,0,0}
		for _pId = 1,8 do
			_nr[_pId] = Logic.GetNumberOfWorkerWithoutSleepPlace(_pId)
		end
		return _nr		
	end
	
	StatisticLogJob = function()
		if Logic.GetTime() >= NextStatisticLog then	
			NextStatisticLog = NextStatisticLog + StatisticsLog.Timer
			LogCurrentStatistic()
		end
	end
	LogCurrentStatistic = function()
		local _soliders = GetNumberOfSoldiers()
		local _serfs = GetNumberOfSerfs()
		local _settlers = GetNumberOfSettlers()
		local _workers = {}
		local _noeatplaces = GetNumberOfWorkerWithoutEatPlace()
		local _nosleepplaces = GetNumberOfWorkerWithoutSleepPlace()
		local _eatplaces = {}
		local _sleepplaces = {}
		local _gold = {}
		local _clay = {}
		local _wood = {}
		local _stone = {}
		local _iron = {}
		local _sulfur = {}		
		for i = 1 ,8 do
			_workers[i] = _settlers[i] - _serfs[i] - _soliders[i]
			_eatplaces[i] = _workers[i] - _noeatplaces[i]
			_sleepplaces[i] = _workers[i] - _nosleepplaces[i]
			_gold[i] = GetGold(i)
			_clay[i] = GetClay(i)
			_wood[i] = GetWood(i)
			_stone[i] = GetStone(i)
			_iron[i] = GetIron(i)
			_sulfur[i] = GetSulfur(i)		
		end
		for i = 1,8 do
			table.insert(StatisticsLog.Gold[i], _gold[i])		
			table.insert(StatisticsLog.Clay[i], _clay[i])	
			table.insert(StatisticsLog.Wood[i], _wood[i])	
			table.insert(StatisticsLog.Stone[i], _stone[i])		
			table.insert(StatisticsLog.Iron[i], _iron[i])		
			table.insert(StatisticsLog.Sulfur[i], _sulfur[i])
			table.insert(StatisticsLog.Soldiers[i], _soliders[i])
			table.insert(StatisticsLog.Serfs[i], _serfs[i])
			table.insert(StatisticsLog.Workers[i], _workers[i])
			table.insert(StatisticsLog.SleepPlace[i], _sleepplaces[i])
			table.insert(StatisticsLog.EatPlace[i], _eatplaces[i])
		end
	end
	StatisticsStringOutPut = function()
		XNetwork.Manager_RestartAsServer_SinglePlayer()
		EndJob(StatisticLogJobId)
		gv_StatisticsWaitSeconds = 2
		StatisticsOutputJobId = StartSimpleJob("StatisticsOutputJob")	
	end

	function StatisticsOutputAllBriefing()
		local briefing = {}
		local AP = function( _page ) table.insert( briefing, _page ); return _page; end
	 
		-- Seite 1
		local choicePage = AP{ 			
			mc 	 = {					
				title	= "Statistikausgabe",
				text 	= "Moechtest du erweiterte Statistiken ausgeben? Achtung! Dies kann eine lange Prozedur sein!",
				firstText   = "Ja",
				secondText  = "Nein",
				firstSelected  = 2,   -- Regen   -> Seite 2
				secondSelected = 4,   -- Schnee -> Seite 4
			},
			dialogCamera	=	true,
		}
		AP{text = "Los gehts...",}
		AP()
		AP{ text = "Du kannst das Spiel jetzt verlassen...",}
		briefing.finished =
			function()
				if GetSelectedBriefingMCButton( choicePage ) == 1 then -- Erste Antwort gewhlt?
					StatisticsOutputJobId = StartSimpleJob( "StatisticsOutputJob" )
				end
			end
		StartBriefing( briefing)
		-- soll dieses Briefing nicht aus einer anderen Funktion heraus aufgerufen werden,
		-- kann hier statt StartBriefing auch ein NPC erzeugt werden
	 
	end

	StatisticsLog.OutPutRow = {"Gold","Clay","Wood","Stone","Iron","Sulfur","Soldiers","Serfs","Workers","SleepPlace","EatPlace"}
	StatisticsLog.FirstNew = true
	StatisticsLog.CurrentText = ""
	StatisticsLog.CurrentNotDone = true
	StatisticsLog.CurrentOutput = 1
	StatisticsLog.CurrentRow = 1
	StatisticsLog.GeneralGameInfoOutputted = false
	enter=string.char(13)
	tab=string.char(9)
	StatisticsLog.outputstring = enter

	StatisticsOutputJob = function()

		if gv_StatisticsWaitSeconds == 0 then
			if not (StatisticsLog.GeneralGameInfoOutputted) then
				-------- ALLGEMEINE SPIELSTATISTIKEN AUSGABE ---------
				StatisticsLog.GeneralGameInfoOutputted = true
				local _Spieler = "Spieler:"
				local _Teams = "Team:"
				local _SpielEndeZeit = "Spielende bei:"
				local _SpielEndeStatus = "Status:"
				for i = 1,8 do
					if not (StatisticsLog.PlayerNames[i] == "") then
						_Spieler = _Spieler..tab..StatisticsLog.PlayerNames[i]
						_Teams = _Teams..tab..StatisticsLog.PlayerTeams[i]
						if not (StatisticsLog.PlayerEndGame.Time[i] == 0) then
							_SpielEndeZeit = _SpielEndeZeit..tab..math.floor(StatisticsLog.PlayerEndGame.Time[i] / 60)..". Minute"
						else
							_SpielEndeZeit = _SpielEndeZeit..tab.."nicht ermittelt!"
						end
						if StatisticsLog.PlayerEndGame.State[i] == 2 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."Win"
						elseif StatisticsLog.PlayerEndGame.State[i] == 3 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."Lost"
						elseif StatisticsLog.PlayerEndGame.State[i] == 0 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."nicht ermittelt!"
						elseif StatisticsLog.PlayerEndGame.State[i] == 4 then
							_SpielEndeStatus = _SpielEndeStatus..tab.."Quitted"
						end		
					end
				end
				StatisticsLog.outputstring = StatisticsLog.outputstring.._Spieler..enter.._Teams..enter.._SpielEndeZeit..enter.._SpielEndeStatus..enter
				EndJob( StatisticsOutputJobId )
				StatisticsOutputAllBriefing()
				assert(false,StatisticsLog.outputstring)
			else
				-------- RESOURCEN AUSGABE ---------
				StatisticsLog.outputstring = StatisticsLog.CurrentText				
				if StatisticsLog.FirstNew then
					StatisticsLog.outputstring = enter..StatisticsLog.OutPutRow[StatisticsLog.CurrentOutput]
					for _pId = 1,8 do			
						if not (StatisticsLog.PlayerNames[_pId] == "") then
							StatisticsLog.outputstring = StatisticsLog.outputstring..tab..StatisticsLog.PlayerNames[_pId]
						end
					end
					StatisticsLog.outputstring = StatisticsLog.outputstring..enter
					StatisticsLog.FirstNew = false
				end
				for u = StatisticsLog.CurrentRow, table.getn (StatisticsLog.Gold[1]) do
					StatisticsLog.CurrentText = StatisticsLog.Timer * (u-1)
					for _pId = 1,8 do
						if not (StatisticsLog.PlayerNames[_pId] == "") then
							StatisticsLog.CurrentText = StatisticsLog.CurrentText..tab..StatisticsLog[StatisticsLog.OutPutRow[StatisticsLog.CurrentOutput]][_pId][u]
						end
					end
					StatisticsLog.CurrentText = StatisticsLog.CurrentText..enter
					if ( string.len(StatisticsLog.outputstring) + string.len(StatisticsLog.CurrentText) ) > 750 then
							StatisticsLog.CurrentRow = u + 1
							StatisticsLog.CurrentText = StatisticsLog.CurrentText
							assert(false,StatisticsLog.outputstring)-- Hier kommt der Abbruch, aber die Liste ist noch nicht fertig
					else
						StatisticsLog.outputstring = StatisticsLog.outputstring..StatisticsLog.CurrentText
						StatisticsLog.CurrentText = ""
					end				
				end
				StatisticsLog.CurrentOutput = StatisticsLog.CurrentOutput + 1
				if StatisticsLog.CurrentOutput > table.getn (StatisticsLog.OutPutRow) then
					EndJob( StatisticsOutputJobId )
				end
				StatisticsLog.CurrentRow = 1
				StatisticsLog.CurrentText = ""
				StatisticsLog.FirstNew = true
				assert(false,StatisticsLog.outputstring)			
			end
		end
		gv_StatisticsWaitSeconds = gv_StatisticsWaitSeconds - 1		
	end
	if StatisticsLog.PlayerNames[1] == "" then
		StatisticsLog.PlayerNames[1] = UserTool_GetPlayerName(1)
		AddTribute( CreateATribute(gv_guipId, "Spielstatistiken ausgeben (Achtung, du verlaesst dadurch das Spiel!)", { Gold = 0}, StatisticsStringOutPut ) )
	end	
	StatisticsLog.Timer = 30

end
function Setup_GUIHacks()
	SetupGUIHack("GUITooltip_ConstructBuilding")
	SetupGUIHack("SellBuilding","GUI")
	SetupGUIHack("GUIAction_DoNotDestroyBuilding")
	SetupGUIHack("GameCallback_OnBuildingConstructionComplete")
	SetupGUIHack("GUITooltip_ResearchTechnologies")
	SetupGUIHack("GUIUpdate_Armor")
	SetupGUIHack("MPTrade_ChangeResourceAmount","GUI")
	SetupGUIHack("KeyBindings_TogglePause")
	SetupGUIHack("GUIAction_PlaceBuilding")
	SetupGUIHack("GUIAction_BlessSettlers")
	SetupGUIHack("GUITooltip_UpgradeBuilding")
	SetupGUIHack("GUIAction_ToggleMenu")
	SetupGUIHack("GameCallback_GUI_SelectionChanged")
	-- ##############################
	-- Funktion Hack
	table.insert(GUITooltip_ResearchTechnologies_BeforeOrig,
		function(...)		
			if arg[1] == 1 then
				if Logic.IsTechnologyResearched( _pID, arg[1] ) == 1 then
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Wehrpflicht @cr @color:255,255,255 Nun knnt ihr Kasernen und Mauern errichten" )
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 50 @cr Holz: 150" )					
				else
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Wehrpflicht @cr @color:252,164,39 Ermglicht: @color:255,255,255 Kaserne, Mauern" )
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 50 @cr Holz: 150" )		
				end				
				return false
			end
			if arg[1] == 2 then
				if Logic.IsTechnologyResearched( _pID, arg[1] ) == 1 then
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Stehendes Heer @cr @color:255,255,255 Nun knnt ihr Schiepltze bauen und dort Schtzen rekrutieren. Ausserdem knnt ihr Tore fr eure Schutzwlle errichten" )
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 200 @cr Eisen: 200" )					
				else
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Stehendes Heer @cr @color:252,164,39 Ermglicht: @color:255,255,255 Kampfformationen, Schieplatz, Tore" )
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 200 @cr Eisen: 200" )	
				end				
				return false
			end
			if arg[1] == 3 then
				if Logic.IsTechnologyResearched( _pID, arg[1] ) == 1 then
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Taktiken @cr @color:255,255,255 Nun knnt ihr Stlle fr berittene Einheiten bauen. Ausserdem knnt ihr eine Abschlussmauer bauen." )
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 400 @cr Eisen: 400" )					
				else
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomText, "@color:180,180,180 Taktiken @cr @color:252,164,39 Ermglicht: @color:255,255,255 Stall, taktische Karte, Abschlussmauer" )
					XGUIEng.SetText( gvGUI_WidgetID.TooltipBottomCosts, "Taler: 400 @cr Eisen: 400" )
				end				
				return false
			end
		end
	)
	-- MPC Hacks
	table.insert(GameCallback_GUI_SelectionChanged_AfterOrig,
		function(...)
			if mpc_GameStartDelay > 0 then
				XGUIEng.ShowWidget( gvGUI_WidgetID.DestroyBuilding, 0 );
            end					
			EndJob( gvTradeLimitJob )
			if mpc_Rules.TradeLimit.Cur > 1 then
				if Logic.GetEntityType( GUI.GetSelectedEntity() ) == 37 then
					gvTradeLimitJob = StartSimpleHiResJob( "Max_Tradevalue_Limiting" )
				end			
			end			
		end
	)
	table.insert(GUI.MPTrade_ChangeResourceAmount_BeforeOrig,
		function(_resId,_change)
			if XGUIEng.IsModifierPressed(Keys.ModifierAlt) == 1 then
				GUI.MPTrade_ChangeResourceAmount_orig(_resId,_change*5)
				return false
			end	
		end
	)
	table.insert(KeyBindings_TogglePause_BeforeOrig,
		function(...)
			if mpc_Rules["Special1"].Act[6] == true then
				if not(gv_guipId == setuppId) then
					return false
				end
			else
				if not(mpc_MultiplayerPlaying[gv_guipId]) then
					return false
				end
			end
		end
	)
	-- Verbot fr Spieler 8 fr Tribut-Fenster weil dort die Multiplayer-Tribute drin sind
	table.insert(GUIAction_ToggleMenu_BeforeOrig,
		function(...)
			if (arg[1] == "TradeWindow" or arg[1] == 51) and gv_guipId == 8 then
				GUIAction_ToggleMenu_OrigProtected(arg[1],0)
				return false
            end	
		end
	)	
	
	DestroyThisTowerBecauseMax = function(_eId)
		DestroyEntity(_eId)
		return true
	end
	CheckMaxTowersOnEntityCreated = function()
		local _eId = Event.GetEntityID()
		local _eType = Logic.GetEntityType( _eId )
		local _pId = GetPlayer(_eId)
		if _eType == gv_Entities_Tuerme[1] or _eType == gv_Entities_Tuerme[7] then		
			if mpc_Rules["Special2"].Act[4] then
				local _towercounter = 0				
				for i = 1, table.getn(gv_Entities_Tuerme) do
					_towercounter = _towercounter + table.getn( Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ] )
					for u = 1, table.getn(mpc_towers[_pId][i]) do
						for v = 1, table.getn( Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ] ) do
							if mpc_towers[_pId][i][u] == Track_Entity_Table[_pId][ gv_Entities_Tuerme[i] ][v]  then
								_towercounter = _towercounter - 1
							end
						end
					end
				end
				if mpc_Rules["Maxtowers"][mpc_Rules["Maxtowers"].Cur] <= _towercounter then
					StartSimpleJob(DestroyThisTowerBecauseMax,_eId)
					if _pId == gv_guipId then
						Message(g_MC_Loc[2].Rule["Maxtowers"].Msg..": "..mpc_Rules["Maxtowers"][mpc_Rules["Maxtowers"].Cur])
					end
					return false
				end
			end	
		end
	end
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "CheckMaxTowersOnEntityCreated", 1)	
	table.insert(GUIAction_PlaceBuilding_BeforeOrig,
		function(...)
			if mpc_Rules["Special2"].Act[4] then
				if arg[1] == UpgradeCategories.Tower or arg[1] == UpgradeCategories.Beautification03 then
					local _towercounter = 0				
					for i = 1, table.getn(gv_Entities_Tuerme) do
						_towercounter = _towercounter + table.getn( Track_Entity_Table[gv_guipId][ gv_Entities_Tuerme[i] ] )
						for u = 1, table.getn(mpc_towers[gv_guipId][i]) do
							for v = 1, table.getn( Track_Entity_Table[gv_guipId][ gv_Entities_Tuerme[i] ] ) do
								if mpc_towers[gv_guipId][i][u] == Track_Entity_Table[gv_guipId][ gv_Entities_Tuerme[i] ][v]  then
									_towercounter = _towercounter - 1
								end
							end
						end
					end
					if mpc_Rules["Maxtowers"][mpc_Rules["Maxtowers"].Cur] <= _towercounter then
						Message(g_MC_Loc[2].Rule["Maxtowers"].Msg..": "..mpc_Rules["Maxtowers"][mpc_Rules["Maxtowers"].Cur])
						return false
					end
				end
			end
		end
	)	
	table.insert(GUIAction_BlessSettlers_BeforeOrig,
		function(...)
			if mpc_Rules["Special1"].Act[2] then	
				if mpc_Rules.BlessTimer[gv_guipId][arg[1]] > (Logic.GetTime() - mpc_Rules["Special1"].TimeBetweenBlessings) then		
					if Logic.GetPlayersGlobalResource(gv_guipId,ResourceType.Faith) >= 5000 then
						Message( g_MC_Loc[lang].ClericMsgFix..gvCol.rot.." "..math.floor(-1*(Logic.GetTime() - mpc_Rules["Special1"].TimeBetweenBlessings - mpc_Rules.BlessTimer[gv_guipId][arg[1]])).." "..g_MC_Loc[lang].Seconds )
						return false
					end
				else
					local _blockbless = math.floor(Logic.GetTime()+0.5)
					if Logic.GetPlayersGlobalResource(gv_guipId,ResourceType.Faith) >= 5000 then
						if BlessCategories.Canonisation == arg[1] then
							mpc_Rules.BlessTimer[gv_guipId][BlessCategories.Construction] = _blockbless
							mpc_Rules.BlessTimer[gv_guipId][BlessCategories.Research] = _blockbless
							mpc_Rules.BlessTimer[gv_guipId][BlessCategories.Weapons] = _blockbless
							mpc_Rules.BlessTimer[gv_guipId][BlessCategories.Financial] = _blockbless
						else
							mpc_Rules.BlessTimer[gv_guipId][arg[1]] = _blockbless
						end
						mpc_Rules.BlessTimer[gv_guipId][BlessCategories.Canonisation] = _blockbless
					end
				end
			end
		end
	)
		
end

SetupGUIHack = function(_gui,_mothertable)
	_mothertable = _mothertable or 0
	if _mothertable ~= 0 then
		if not(type(_G[_mothertable][_gui.."_BeforeOrig"]) == "table") then
			_G[_mothertable][_gui.."_BeforeOrig"] = {}
			_G[_mothertable][_gui.."_AfterOrig"] = {}
			_G[_mothertable][_gui.."_OrigProtected"] = _G[_mothertable][_gui]
			_G[_mothertable][_gui] = function(...)
				local DoOrig = true
				local _result
				for i = 1,table.getn(_G[_mothertable][_gui.."_BeforeOrig"]) do if _G[_mothertable][_gui.."_BeforeOrig"][i](unpack(arg)) == false then DoOrig = false end end
				if DoOrig then _result = _G[_mothertable][_gui.."_OrigProtected"](unpack(arg)) end
				for i = 1,table.getn(_G[_mothertable][_gui.."_AfterOrig"]) do _G[_mothertable][_gui.."_AfterOrig"][i](unpack(arg)) end
				return _result
			end
		end
	else
		if not(type(_G[_gui.."_BeforeOrig"]) == "table") then
			_G[_gui.."_BeforeOrig"] = {}
			_G[_gui.."_AfterOrig"] = {}
			_G[_gui.."_OrigProtected"] = _G[_gui]
			_G[_gui] = function(...)
				local DoOrig = true
				local _result
				for i = 1,table.getn(_G[_gui.."_BeforeOrig"]) do if _G[_gui.."_BeforeOrig"][i](unpack(arg)) == false then DoOrig = false end end --_G[_gui.."_BeforeOrig"][i](unpack(arg)) end
				if DoOrig then _result = _G[_gui.."_OrigProtected"](unpack(arg)) end
				for i = 1,table.getn(_G[_gui.."_AfterOrig"]) do _G[_gui.."_AfterOrig"][i](unpack(arg)) end
				return _result
			end
		end
	end
end
AllesHacken = function()
	local _CurrentGFunction = ""
	SetupGUIHack("GUIAction_ToggleMenu")	
	function Hack_Funktion(was) 
		if (type(_G[was]) == "function") then
			--Message(was)
			if string.find(was, "GUI") or string.find(was, "GameCallback") or string.find(was, "KeyBindings") then
				SetupGUIHack(was)	
			end
		elseif (type(_G[was]) == "table") then
			if was == "GUI" or was == "XGUIEng" then
				_CurrentGFunction = was
				table.foreach(_G[was],Hack_GFunktion)		
			end
		end
	end
	function Hack_GFunktion(was) 
		if (type(_G[_CurrentGFunction][was]) == "function") then
			SetupGUIHack(was,_CurrentGFunction)	
		end
	end
	table.foreach(_G     ,Hack_Funktion)
end

end